package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExportTask(
    description: Optional[String] = Optional.Absent,
    exportTaskId: Optional[String] = Optional.Absent,
    exportToS3Task: Optional[zio.aws.ec2.model.ExportToS3Task] =
      Optional.Absent,
    instanceExportDetails: Optional[zio.aws.ec2.model.InstanceExportDetails] =
      Optional.Absent,
    state: Optional[zio.aws.ec2.model.ExportTaskState] = Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.ExportTask = {
    import ExportTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ExportTask
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(exportTaskId.map(value => value: java.lang.String))(
        _.exportTaskId
      )
      .optionallyWith(exportToS3Task.map(value => value.buildAwsValue()))(
        _.exportToS3Task
      )
      .optionallyWith(
        instanceExportDetails.map(value => value.buildAwsValue())
      )(_.instanceExportDetails)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ExportTask.ReadOnly =
    zio.aws.ec2.model.ExportTask.wrap(buildAwsValue())
}
object ExportTask {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.ExportTask] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ExportTask = zio.aws.ec2.model.ExportTask(
      description.map(value => value),
      exportTaskId.map(value => value),
      exportToS3Task.map(value => value.asEditable),
      instanceExportDetails.map(value => value.asEditable),
      state.map(value => value),
      statusMessage.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def description: Optional[String]
    def exportTaskId: Optional[String]
    def exportToS3Task: Optional[zio.aws.ec2.model.ExportToS3Task.ReadOnly]
    def instanceExportDetails
        : Optional[zio.aws.ec2.model.InstanceExportDetails.ReadOnly]
    def state: Optional[zio.aws.ec2.model.ExportTaskState]
    def statusMessage: Optional[String]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getExportTaskId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("exportTaskId", exportTaskId)
    def getExportToS3Task
        : ZIO[Any, AwsError, zio.aws.ec2.model.ExportToS3Task.ReadOnly] =
      AwsError.unwrapOptionField("exportToS3Task", exportToS3Task)
    def getInstanceExportDetails
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceExportDetails.ReadOnly] =
      AwsError.unwrapOptionField("instanceExportDetails", instanceExportDetails)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.ExportTaskState] =
      AwsError.unwrapOptionField("state", state)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ExportTask
  ) extends zio.aws.ec2.model.ExportTask.ReadOnly {
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val exportTaskId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.exportTaskId())
      .map(value => value: String)
    override val exportToS3Task
        : Optional[zio.aws.ec2.model.ExportToS3Task.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exportToS3Task())
        .map(value => zio.aws.ec2.model.ExportToS3Task.wrap(value))
    override val instanceExportDetails
        : Optional[zio.aws.ec2.model.InstanceExportDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceExportDetails())
        .map(value => zio.aws.ec2.model.InstanceExportDetails.wrap(value))
    override val state: Optional[zio.aws.ec2.model.ExportTaskState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.ExportTaskState.wrap(value))
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ExportTask
  ): zio.aws.ec2.model.ExportTask.ReadOnly = new Wrapper(impl)
}
