package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EnableVpcClassicLinkRequest(vpcId: VpcId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkRequest = {
    import EnableVpcClassicLinkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkRequest
      .builder()
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.EnableVpcClassicLinkRequest.ReadOnly =
    zio.aws.ec2.model.EnableVpcClassicLinkRequest.wrap(buildAwsValue())
}
object EnableVpcClassicLinkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EnableVpcClassicLinkRequest =
      zio.aws.ec2.model.EnableVpcClassicLinkRequest(vpcId)
    def vpcId: VpcId
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkRequest
  ) extends zio.aws.ec2.model.EnableVpcClassicLinkRequest.ReadOnly {
    override val vpcId: VpcId = zio.aws.ec2.model.primitives.VpcId(impl.vpcId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EnableVpcClassicLinkRequest
  ): zio.aws.ec2.model.EnableVpcClassicLinkRequest.ReadOnly = new Wrapper(impl)
}
