package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DiskImageDetail(
    bytes: Long,
    format: zio.aws.ec2.model.DiskImageFormat,
    importManifestUrl: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DiskImageDetail = {
    import DiskImageDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DiskImageDetail
      .builder()
      .bytes(bytes: java.lang.Long)
      .format(format.unwrap)
      .importManifestUrl(importManifestUrl: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DiskImageDetail.ReadOnly =
    zio.aws.ec2.model.DiskImageDetail.wrap(buildAwsValue())
}
object DiskImageDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DiskImageDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DiskImageDetail =
      zio.aws.ec2.model.DiskImageDetail(bytes, format, importManifestUrl)
    def bytes: Long
    def format: zio.aws.ec2.model.DiskImageFormat
    def importManifestUrl: String
    def getBytes: ZIO[Any, Nothing, Long] = ZIO.succeed(bytes)
    def getFormat: ZIO[Any, Nothing, zio.aws.ec2.model.DiskImageFormat] =
      ZIO.succeed(format)
    def getImportManifestUrl: ZIO[Any, Nothing, String] =
      ZIO.succeed(importManifestUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DiskImageDetail
  ) extends zio.aws.ec2.model.DiskImageDetail.ReadOnly {
    override val bytes: Long = impl.bytes(): Long
    override val format: zio.aws.ec2.model.DiskImageFormat =
      zio.aws.ec2.model.DiskImageFormat.wrap(impl.format())
    override val importManifestUrl: String = impl.importManifestUrl(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DiskImageDetail
  ): zio.aws.ec2.model.DiskImageDetail.ReadOnly = new Wrapper(impl)
}
