package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeExportTasksResponse(
    exportTasks: Optional[Iterable[zio.aws.ec2.model.ExportTask]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeExportTasksResponse = {
    import DescribeExportTasksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeExportTasksResponse
      .builder()
      .optionallyWith(
        exportTasks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.exportTasks)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeExportTasksResponse.ReadOnly =
    zio.aws.ec2.model.DescribeExportTasksResponse.wrap(buildAwsValue())
}
object DescribeExportTasksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeExportTasksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeExportTasksResponse =
      zio.aws.ec2.model.DescribeExportTasksResponse(
        exportTasks.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def exportTasks: Optional[List[zio.aws.ec2.model.ExportTask.ReadOnly]]
    def getExportTasks
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.ExportTask.ReadOnly]] =
      AwsError.unwrapOptionField("exportTasks", exportTasks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeExportTasksResponse
  ) extends zio.aws.ec2.model.DescribeExportTasksResponse.ReadOnly {
    override val exportTasks
        : Optional[List[zio.aws.ec2.model.ExportTask.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exportTasks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ExportTask.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeExportTasksResponse
  ): zio.aws.ec2.model.DescribeExportTasksResponse.ReadOnly = new Wrapper(impl)
}
