package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CustomerGateway(
    bgpAsn: Optional[String] = Optional.Absent,
    customerGatewayId: Optional[String] = Optional.Absent,
    ipAddress: Optional[String] = Optional.Absent,
    certificateArn: Optional[String] = Optional.Absent,
    state: Optional[String] = Optional.Absent,
    `type`: Optional[String] = Optional.Absent,
    deviceName: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CustomerGateway = {
    import CustomerGateway.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CustomerGateway
      .builder()
      .optionallyWith(bgpAsn.map(value => value: java.lang.String))(_.bgpAsn)
      .optionallyWith(customerGatewayId.map(value => value: java.lang.String))(
        _.customerGatewayId
      )
      .optionallyWith(ipAddress.map(value => value: java.lang.String))(
        _.ipAddress
      )
      .optionallyWith(certificateArn.map(value => value: java.lang.String))(
        _.certificateArn
      )
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(deviceName.map(value => value: java.lang.String))(
        _.deviceName
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CustomerGateway.ReadOnly =
    zio.aws.ec2.model.CustomerGateway.wrap(buildAwsValue())
}
object CustomerGateway {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CustomerGateway
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CustomerGateway =
      zio.aws.ec2.model.CustomerGateway(
        bgpAsn.map(value => value),
        customerGatewayId.map(value => value),
        ipAddress.map(value => value),
        certificateArn.map(value => value),
        state.map(value => value),
        `type`.map(value => value),
        deviceName.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def bgpAsn: Optional[String]
    def customerGatewayId: Optional[String]
    def ipAddress: Optional[String]
    def certificateArn: Optional[String]
    def state: Optional[String]
    def `type`: Optional[String]
    def deviceName: Optional[String]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getBgpAsn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bgpAsn", bgpAsn)
    def getCustomerGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("customerGatewayId", customerGatewayId)
    def getIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("state", state)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
    def getDeviceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deviceName", deviceName)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CustomerGateway
  ) extends zio.aws.ec2.model.CustomerGateway.ReadOnly {
    override val bgpAsn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.bgpAsn())
      .map(value => value: String)
    override val customerGatewayId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.customerGatewayId())
      .map(value => value: String)
    override val ipAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddress())
      .map(value => value: String)
    override val certificateArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateArn())
      .map(value => value: String)
    override val state: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value => value: String)
    override val `type`: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => value: String)
    override val deviceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceName())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CustomerGateway
  ): zio.aws.ec2.model.CustomerGateway.ReadOnly = new Wrapper(impl)
}
