package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ClientVpnEndpointStatusCode {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.ClientVpnEndpointStatusCode
}
object ClientVpnEndpointStatusCode {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ClientVpnEndpointStatusCode
  ): zio.aws.ec2.model.ClientVpnEndpointStatusCode = value match {
    case software.amazon.awssdk.services.ec2.model.ClientVpnEndpointStatusCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ClientVpnEndpointStatusCode.PENDING_ASSOCIATE =>
      val r = `pending-associate`
      r
    case software.amazon.awssdk.services.ec2.model.ClientVpnEndpointStatusCode.AVAILABLE =>
      val r = available
      r
    case software.amazon.awssdk.services.ec2.model.ClientVpnEndpointStatusCode.DELETING =>
      val r = deleting
      r
    case software.amazon.awssdk.services.ec2.model.ClientVpnEndpointStatusCode.DELETED =>
      val r = deleted
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.ClientVpnEndpointStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ClientVpnEndpointStatusCode =
      software.amazon.awssdk.services.ec2.model.ClientVpnEndpointStatusCode.UNKNOWN_TO_SDK_VERSION
  }
  case object `pending-associate`
      extends zio.aws.ec2.model.ClientVpnEndpointStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ClientVpnEndpointStatusCode =
      software.amazon.awssdk.services.ec2.model.ClientVpnEndpointStatusCode.PENDING_ASSOCIATE
  }
  case object available extends zio.aws.ec2.model.ClientVpnEndpointStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ClientVpnEndpointStatusCode =
      software.amazon.awssdk.services.ec2.model.ClientVpnEndpointStatusCode.AVAILABLE
  }
  case object deleting extends zio.aws.ec2.model.ClientVpnEndpointStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ClientVpnEndpointStatusCode =
      software.amazon.awssdk.services.ec2.model.ClientVpnEndpointStatusCode.DELETING
  }
  case object deleted extends zio.aws.ec2.model.ClientVpnEndpointStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ClientVpnEndpointStatusCode =
      software.amazon.awssdk.services.ec2.model.ClientVpnEndpointStatusCode.DELETED
  }
}
