package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  SecurityGroupId,
  VpcId,
  ClientVpnEndpointId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ApplySecurityGroupsToClientVpnTargetNetworkRequest(
    clientVpnEndpointId: ClientVpnEndpointId,
    vpcId: VpcId,
    securityGroupIds: Iterable[SecurityGroupId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkRequest = {
    import ApplySecurityGroupsToClientVpnTargetNetworkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkRequest
      .builder()
      .clientVpnEndpointId(
        ClientVpnEndpointId.unwrap(clientVpnEndpointId): java.lang.String
      )
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .securityGroupIds(securityGroupIds.map { item =>
        SecurityGroupId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkRequest.ReadOnly =
    zio.aws.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkRequest
      .wrap(buildAwsValue())
}
object ApplySecurityGroupsToClientVpnTargetNetworkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkRequest =
      zio.aws.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkRequest(
        clientVpnEndpointId,
        vpcId,
        securityGroupIds
      )
    def clientVpnEndpointId: ClientVpnEndpointId
    def vpcId: VpcId
    def securityGroupIds: List[SecurityGroupId]
    def getClientVpnEndpointId: ZIO[Any, Nothing, ClientVpnEndpointId] =
      ZIO.succeed(clientVpnEndpointId)
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
    def getSecurityGroupIds: ZIO[Any, Nothing, List[SecurityGroupId]] =
      ZIO.succeed(securityGroupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkRequest
  ) extends zio.aws.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkRequest.ReadOnly {
    override val clientVpnEndpointId: ClientVpnEndpointId =
      zio.aws.ec2.model.primitives
        .ClientVpnEndpointId(impl.clientVpnEndpointId())
    override val vpcId: VpcId = zio.aws.ec2.model.primitives.VpcId(impl.vpcId())
    override val securityGroupIds: List[SecurityGroupId] = impl
      .securityGroupIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.SecurityGroupId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkRequest
  ): zio.aws.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkRequest.ReadOnly =
    new Wrapper(impl)
}
