package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UserBucket(
    s3Bucket: Optional[String] = Optional.Absent,
    s3Key: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.UserBucket = {
    import UserBucket.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.UserBucket
      .builder()
      .optionallyWith(s3Bucket.map(value => value: java.lang.String))(
        _.s3Bucket
      )
      .optionallyWith(s3Key.map(value => value: java.lang.String))(_.s3Key)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.UserBucket.ReadOnly =
    zio.aws.ec2.model.UserBucket.wrap(buildAwsValue())
}
object UserBucket {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.UserBucket] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.UserBucket = zio.aws.ec2.model
      .UserBucket(s3Bucket.map(value => value), s3Key.map(value => value))
    def s3Bucket: Optional[String]
    def s3Key: Optional[String]
    def getS3Bucket: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3Bucket", s3Bucket)
    def getS3Key: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3Key", s3Key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.UserBucket
  ) extends zio.aws.ec2.model.UserBucket.ReadOnly {
    override val s3Bucket: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Bucket())
      .map(value => value: String)
    override val s3Key: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Key())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.UserBucket
  ): zio.aws.ec2.model.UserBucket.ReadOnly = new Wrapper(impl)
}
