package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TransitGatewayOptions(
    amazonSideAsn: Optional[Long] = Optional.Absent,
    transitGatewayCidrBlocks: Optional[Iterable[String]] = Optional.Absent,
    autoAcceptSharedAttachments: Optional[
      zio.aws.ec2.model.AutoAcceptSharedAttachmentsValue
    ] = Optional.Absent,
    defaultRouteTableAssociation: Optional[
      zio.aws.ec2.model.DefaultRouteTableAssociationValue
    ] = Optional.Absent,
    associationDefaultRouteTableId: Optional[String] = Optional.Absent,
    defaultRouteTablePropagation: Optional[
      zio.aws.ec2.model.DefaultRouteTablePropagationValue
    ] = Optional.Absent,
    propagationDefaultRouteTableId: Optional[String] = Optional.Absent,
    vpnEcmpSupport: Optional[zio.aws.ec2.model.VpnEcmpSupportValue] =
      Optional.Absent,
    dnsSupport: Optional[zio.aws.ec2.model.DnsSupportValue] = Optional.Absent,
    multicastSupport: Optional[zio.aws.ec2.model.MulticastSupportValue] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayOptions = {
    import TransitGatewayOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayOptions
      .builder()
      .optionallyWith(amazonSideAsn.map(value => value: java.lang.Long))(
        _.amazonSideAsn
      )
      .optionallyWith(
        transitGatewayCidrBlocks.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.transitGatewayCidrBlocks)
      .optionallyWith(autoAcceptSharedAttachments.map(value => value.unwrap))(
        _.autoAcceptSharedAttachments
      )
      .optionallyWith(defaultRouteTableAssociation.map(value => value.unwrap))(
        _.defaultRouteTableAssociation
      )
      .optionallyWith(
        associationDefaultRouteTableId.map(value => value: java.lang.String)
      )(_.associationDefaultRouteTableId)
      .optionallyWith(defaultRouteTablePropagation.map(value => value.unwrap))(
        _.defaultRouteTablePropagation
      )
      .optionallyWith(
        propagationDefaultRouteTableId.map(value => value: java.lang.String)
      )(_.propagationDefaultRouteTableId)
      .optionallyWith(vpnEcmpSupport.map(value => value.unwrap))(
        _.vpnEcmpSupport
      )
      .optionallyWith(dnsSupport.map(value => value.unwrap))(_.dnsSupport)
      .optionallyWith(multicastSupport.map(value => value.unwrap))(
        _.multicastSupport
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGatewayOptions.ReadOnly =
    zio.aws.ec2.model.TransitGatewayOptions.wrap(buildAwsValue())
}
object TransitGatewayOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayOptions =
      zio.aws.ec2.model.TransitGatewayOptions(
        amazonSideAsn.map(value => value),
        transitGatewayCidrBlocks.map(value => value),
        autoAcceptSharedAttachments.map(value => value),
        defaultRouteTableAssociation.map(value => value),
        associationDefaultRouteTableId.map(value => value),
        defaultRouteTablePropagation.map(value => value),
        propagationDefaultRouteTableId.map(value => value),
        vpnEcmpSupport.map(value => value),
        dnsSupport.map(value => value),
        multicastSupport.map(value => value)
      )
    def amazonSideAsn: Optional[Long]
    def transitGatewayCidrBlocks: Optional[List[String]]
    def autoAcceptSharedAttachments
        : Optional[zio.aws.ec2.model.AutoAcceptSharedAttachmentsValue]
    def defaultRouteTableAssociation
        : Optional[zio.aws.ec2.model.DefaultRouteTableAssociationValue]
    def associationDefaultRouteTableId: Optional[String]
    def defaultRouteTablePropagation
        : Optional[zio.aws.ec2.model.DefaultRouteTablePropagationValue]
    def propagationDefaultRouteTableId: Optional[String]
    def vpnEcmpSupport: Optional[zio.aws.ec2.model.VpnEcmpSupportValue]
    def dnsSupport: Optional[zio.aws.ec2.model.DnsSupportValue]
    def multicastSupport: Optional[zio.aws.ec2.model.MulticastSupportValue]
    def getAmazonSideAsn: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("amazonSideAsn", amazonSideAsn)
    def getTransitGatewayCidrBlocks: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("transitGatewayCidrBlocks", transitGatewayCidrBlocks)
    def getAutoAcceptSharedAttachments: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.AutoAcceptSharedAttachmentsValue
    ] = AwsError.unwrapOptionField(
      "autoAcceptSharedAttachments",
      autoAcceptSharedAttachments
    )
    def getDefaultRouteTableAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.DefaultRouteTableAssociationValue
    ] = AwsError.unwrapOptionField(
      "defaultRouteTableAssociation",
      defaultRouteTableAssociation
    )
    def getAssociationDefaultRouteTableId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "associationDefaultRouteTableId",
        associationDefaultRouteTableId
      )
    def getDefaultRouteTablePropagation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.DefaultRouteTablePropagationValue
    ] = AwsError.unwrapOptionField(
      "defaultRouteTablePropagation",
      defaultRouteTablePropagation
    )
    def getPropagationDefaultRouteTableId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "propagationDefaultRouteTableId",
        propagationDefaultRouteTableId
      )
    def getVpnEcmpSupport
        : ZIO[Any, AwsError, zio.aws.ec2.model.VpnEcmpSupportValue] =
      AwsError.unwrapOptionField("vpnEcmpSupport", vpnEcmpSupport)
    def getDnsSupport: ZIO[Any, AwsError, zio.aws.ec2.model.DnsSupportValue] =
      AwsError.unwrapOptionField("dnsSupport", dnsSupport)
    def getMulticastSupport
        : ZIO[Any, AwsError, zio.aws.ec2.model.MulticastSupportValue] =
      AwsError.unwrapOptionField("multicastSupport", multicastSupport)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayOptions
  ) extends zio.aws.ec2.model.TransitGatewayOptions.ReadOnly {
    override val amazonSideAsn: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.amazonSideAsn())
      .map(value => value: Long)
    override val transitGatewayCidrBlocks: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayCidrBlocks())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val autoAcceptSharedAttachments
        : Optional[zio.aws.ec2.model.AutoAcceptSharedAttachmentsValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoAcceptSharedAttachments())
        .map(value =>
          zio.aws.ec2.model.AutoAcceptSharedAttachmentsValue.wrap(value)
        )
    override val defaultRouteTableAssociation
        : Optional[zio.aws.ec2.model.DefaultRouteTableAssociationValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultRouteTableAssociation())
        .map(value =>
          zio.aws.ec2.model.DefaultRouteTableAssociationValue.wrap(value)
        )
    override val associationDefaultRouteTableId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationDefaultRouteTableId())
        .map(value => value: String)
    override val defaultRouteTablePropagation
        : Optional[zio.aws.ec2.model.DefaultRouteTablePropagationValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultRouteTablePropagation())
        .map(value =>
          zio.aws.ec2.model.DefaultRouteTablePropagationValue.wrap(value)
        )
    override val propagationDefaultRouteTableId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.propagationDefaultRouteTableId())
        .map(value => value: String)
    override val vpnEcmpSupport
        : Optional[zio.aws.ec2.model.VpnEcmpSupportValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpnEcmpSupport())
        .map(value => zio.aws.ec2.model.VpnEcmpSupportValue.wrap(value))
    override val dnsSupport: Optional[zio.aws.ec2.model.DnsSupportValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dnsSupport())
        .map(value => zio.aws.ec2.model.DnsSupportValue.wrap(value))
    override val multicastSupport
        : Optional[zio.aws.ec2.model.MulticastSupportValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.multicastSupport())
        .map(value => zio.aws.ec2.model.MulticastSupportValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayOptions
  ): zio.aws.ec2.model.TransitGatewayOptions.ReadOnly = new Wrapper(impl)
}
