package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait TieringOperationStatus {
  def unwrap: software.amazon.awssdk.services.ec2.model.TieringOperationStatus
}
object TieringOperationStatus {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.TieringOperationStatus
  ): zio.aws.ec2.model.TieringOperationStatus = value match {
    case software.amazon.awssdk.services.ec2.model.TieringOperationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.TieringOperationStatus.ARCHIVAL_IN_PROGRESS =>
      val r = `archival-in-progress`
      r
    case software.amazon.awssdk.services.ec2.model.TieringOperationStatus.ARCHIVAL_COMPLETED =>
      val r = `archival-completed`
      r
    case software.amazon.awssdk.services.ec2.model.TieringOperationStatus.ARCHIVAL_FAILED =>
      val r = `archival-failed`
      r
    case software.amazon.awssdk.services.ec2.model.TieringOperationStatus.TEMPORARY_RESTORE_IN_PROGRESS =>
      val r = `temporary-restore-in-progress`
      r
    case software.amazon.awssdk.services.ec2.model.TieringOperationStatus.TEMPORARY_RESTORE_COMPLETED =>
      val r = `temporary-restore-completed`
      r
    case software.amazon.awssdk.services.ec2.model.TieringOperationStatus.TEMPORARY_RESTORE_FAILED =>
      val r = `temporary-restore-failed`
      r
    case software.amazon.awssdk.services.ec2.model.TieringOperationStatus.PERMANENT_RESTORE_IN_PROGRESS =>
      val r = `permanent-restore-in-progress`
      r
    case software.amazon.awssdk.services.ec2.model.TieringOperationStatus.PERMANENT_RESTORE_COMPLETED =>
      val r = `permanent-restore-completed`
      r
    case software.amazon.awssdk.services.ec2.model.TieringOperationStatus.PERMANENT_RESTORE_FAILED =>
      val r = `permanent-restore-failed`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.TieringOperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TieringOperationStatus =
      software.amazon.awssdk.services.ec2.model.TieringOperationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object `archival-in-progress`
      extends zio.aws.ec2.model.TieringOperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TieringOperationStatus =
      software.amazon.awssdk.services.ec2.model.TieringOperationStatus.ARCHIVAL_IN_PROGRESS
  }
  case object `archival-completed`
      extends zio.aws.ec2.model.TieringOperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TieringOperationStatus =
      software.amazon.awssdk.services.ec2.model.TieringOperationStatus.ARCHIVAL_COMPLETED
  }
  case object `archival-failed`
      extends zio.aws.ec2.model.TieringOperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TieringOperationStatus =
      software.amazon.awssdk.services.ec2.model.TieringOperationStatus.ARCHIVAL_FAILED
  }
  case object `temporary-restore-in-progress`
      extends zio.aws.ec2.model.TieringOperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TieringOperationStatus =
      software.amazon.awssdk.services.ec2.model.TieringOperationStatus.TEMPORARY_RESTORE_IN_PROGRESS
  }
  case object `temporary-restore-completed`
      extends zio.aws.ec2.model.TieringOperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TieringOperationStatus =
      software.amazon.awssdk.services.ec2.model.TieringOperationStatus.TEMPORARY_RESTORE_COMPLETED
  }
  case object `temporary-restore-failed`
      extends zio.aws.ec2.model.TieringOperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TieringOperationStatus =
      software.amazon.awssdk.services.ec2.model.TieringOperationStatus.TEMPORARY_RESTORE_FAILED
  }
  case object `permanent-restore-in-progress`
      extends zio.aws.ec2.model.TieringOperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TieringOperationStatus =
      software.amazon.awssdk.services.ec2.model.TieringOperationStatus.PERMANENT_RESTORE_IN_PROGRESS
  }
  case object `permanent-restore-completed`
      extends zio.aws.ec2.model.TieringOperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TieringOperationStatus =
      software.amazon.awssdk.services.ec2.model.TieringOperationStatus.PERMANENT_RESTORE_COMPLETED
  }
  case object `permanent-restore-failed`
      extends zio.aws.ec2.model.TieringOperationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TieringOperationStatus =
      software.amazon.awssdk.services.ec2.model.TieringOperationStatus.PERMANENT_RESTORE_FAILED
  }
}
