package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.MillisecondDateTime
import scala.jdk.CollectionConverters._
final case class SnapshotRecycleBinInfo(
    snapshotId: Optional[String] = Optional.Absent,
    recycleBinEnterTime: Optional[MillisecondDateTime] = Optional.Absent,
    recycleBinExitTime: Optional[MillisecondDateTime] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    volumeId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SnapshotRecycleBinInfo = {
    import SnapshotRecycleBinInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SnapshotRecycleBinInfo
      .builder()
      .optionallyWith(snapshotId.map(value => value: java.lang.String))(
        _.snapshotId
      )
      .optionallyWith(
        recycleBinEnterTime.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.recycleBinEnterTime)
      .optionallyWith(
        recycleBinExitTime.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.recycleBinExitTime)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(volumeId.map(value => value: java.lang.String))(
        _.volumeId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SnapshotRecycleBinInfo.ReadOnly =
    zio.aws.ec2.model.SnapshotRecycleBinInfo.wrap(buildAwsValue())
}
object SnapshotRecycleBinInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SnapshotRecycleBinInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SnapshotRecycleBinInfo =
      zio.aws.ec2.model.SnapshotRecycleBinInfo(
        snapshotId.map(value => value),
        recycleBinEnterTime.map(value => value),
        recycleBinExitTime.map(value => value),
        description.map(value => value),
        volumeId.map(value => value)
      )
    def snapshotId: Optional[String]
    def recycleBinEnterTime: Optional[MillisecondDateTime]
    def recycleBinExitTime: Optional[MillisecondDateTime]
    def description: Optional[String]
    def volumeId: Optional[String]
    def getSnapshotId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getRecycleBinEnterTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("recycleBinEnterTime", recycleBinEnterTime)
    def getRecycleBinExitTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("recycleBinExitTime", recycleBinExitTime)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getVolumeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("volumeId", volumeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SnapshotRecycleBinInfo
  ) extends zio.aws.ec2.model.SnapshotRecycleBinInfo.ReadOnly {
    override val snapshotId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotId())
      .map(value => value: String)
    override val recycleBinEnterTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recycleBinEnterTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val recycleBinExitTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recycleBinExitTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val volumeId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SnapshotRecycleBinInfo
  ): zio.aws.ec2.model.SnapshotRecycleBinInfo.ReadOnly = new Wrapper(impl)
}
