package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  SubnetId,
  KeyPairName,
  SecurityGroupId,
  KernelId,
  ImageId,
  RamdiskId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ScheduledInstancesLaunchSpecification(
    blockDeviceMappings: Optional[
      Iterable[zio.aws.ec2.model.ScheduledInstancesBlockDeviceMapping]
    ] = Optional.Absent,
    ebsOptimized: Optional[Boolean] = Optional.Absent,
    iamInstanceProfile: Optional[
      zio.aws.ec2.model.ScheduledInstancesIamInstanceProfile
    ] = Optional.Absent,
    imageId: ImageId,
    instanceType: Optional[String] = Optional.Absent,
    kernelId: Optional[KernelId] = Optional.Absent,
    keyName: Optional[KeyPairName] = Optional.Absent,
    monitoring: Optional[zio.aws.ec2.model.ScheduledInstancesMonitoring] =
      Optional.Absent,
    networkInterfaces: Optional[
      Iterable[zio.aws.ec2.model.ScheduledInstancesNetworkInterface]
    ] = Optional.Absent,
    placement: Optional[zio.aws.ec2.model.ScheduledInstancesPlacement] =
      Optional.Absent,
    ramdiskId: Optional[RamdiskId] = Optional.Absent,
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    subnetId: Optional[SubnetId] = Optional.Absent,
    userData: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ScheduledInstancesLaunchSpecification = {
    import ScheduledInstancesLaunchSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ScheduledInstancesLaunchSpecification
      .builder()
      .optionallyWith(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappings)
      .optionallyWith(ebsOptimized.map(value => value: java.lang.Boolean))(
        _.ebsOptimized
      )
      .optionallyWith(iamInstanceProfile.map(value => value.buildAwsValue()))(
        _.iamInstanceProfile
      )
      .imageId(ImageId.unwrap(imageId): java.lang.String)
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(
        kernelId.map(value => KernelId.unwrap(value): java.lang.String)
      )(_.kernelId)
      .optionallyWith(
        keyName.map(value => KeyPairName.unwrap(value): java.lang.String)
      )(_.keyName)
      .optionallyWith(monitoring.map(value => value.buildAwsValue()))(
        _.monitoring
      )
      .optionallyWith(
        networkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfaces)
      .optionallyWith(placement.map(value => value.buildAwsValue()))(
        _.placement
      )
      .optionallyWith(
        ramdiskId.map(value => RamdiskId.unwrap(value): java.lang.String)
      )(_.ramdiskId)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(userData.map(value => value: java.lang.String))(
        _.userData
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ScheduledInstancesLaunchSpecification.ReadOnly =
    zio.aws.ec2.model.ScheduledInstancesLaunchSpecification
      .wrap(buildAwsValue())
}
object ScheduledInstancesLaunchSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ScheduledInstancesLaunchSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ScheduledInstancesLaunchSpecification =
      zio.aws.ec2.model.ScheduledInstancesLaunchSpecification(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ebsOptimized.map(value => value),
        iamInstanceProfile.map(value => value.asEditable),
        imageId,
        instanceType.map(value => value),
        kernelId.map(value => value),
        keyName.map(value => value),
        monitoring.map(value => value.asEditable),
        networkInterfaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        placement.map(value => value.asEditable),
        ramdiskId.map(value => value),
        securityGroupIds.map(value => value),
        subnetId.map(value => value),
        userData.map(value => value)
      )
    def blockDeviceMappings: Optional[
      List[zio.aws.ec2.model.ScheduledInstancesBlockDeviceMapping.ReadOnly]
    ]
    def ebsOptimized: Optional[Boolean]
    def iamInstanceProfile: Optional[
      zio.aws.ec2.model.ScheduledInstancesIamInstanceProfile.ReadOnly
    ]
    def imageId: ImageId
    def instanceType: Optional[String]
    def kernelId: Optional[KernelId]
    def keyName: Optional[KeyPairName]
    def monitoring
        : Optional[zio.aws.ec2.model.ScheduledInstancesMonitoring.ReadOnly]
    def networkInterfaces: Optional[
      List[zio.aws.ec2.model.ScheduledInstancesNetworkInterface.ReadOnly]
    ]
    def placement
        : Optional[zio.aws.ec2.model.ScheduledInstancesPlacement.ReadOnly]
    def ramdiskId: Optional[RamdiskId]
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def subnetId: Optional[SubnetId]
    def userData: Optional[String]
    def getBlockDeviceMappings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ScheduledInstancesBlockDeviceMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("blockDeviceMappings", blockDeviceMappings)
    def getEbsOptimized: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getIamInstanceProfile: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ScheduledInstancesIamInstanceProfile.ReadOnly
    ] = AwsError.unwrapOptionField("iamInstanceProfile", iamInstanceProfile)
    def getImageId: ZIO[Any, Nothing, ImageId] = ZIO.succeed(imageId)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getKernelId: ZIO[Any, AwsError, KernelId] =
      AwsError.unwrapOptionField("kernelId", kernelId)
    def getKeyName: ZIO[Any, AwsError, KeyPairName] =
      AwsError.unwrapOptionField("keyName", keyName)
    def getMonitoring: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ScheduledInstancesMonitoring.ReadOnly
    ] = AwsError.unwrapOptionField("monitoring", monitoring)
    def getNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ScheduledInstancesNetworkInterface.ReadOnly
    ]] = AwsError.unwrapOptionField("networkInterfaces", networkInterfaces)
    def getPlacement: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ScheduledInstancesPlacement.ReadOnly
    ] = AwsError.unwrapOptionField("placement", placement)
    def getRamdiskId: ZIO[Any, AwsError, RamdiskId] =
      AwsError.unwrapOptionField("ramdiskId", ramdiskId)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getUserData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userData", userData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstancesLaunchSpecification
  ) extends zio.aws.ec2.model.ScheduledInstancesLaunchSpecification.ReadOnly {
    override val blockDeviceMappings: Optional[
      List[zio.aws.ec2.model.ScheduledInstancesBlockDeviceMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.blockDeviceMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ScheduledInstancesBlockDeviceMapping.wrap(item)
        }.toList
      )
    override val ebsOptimized: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ebsOptimized())
      .map(value => value: Boolean)
    override val iamInstanceProfile: Optional[
      zio.aws.ec2.model.ScheduledInstancesIamInstanceProfile.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.iamInstanceProfile())
      .map(value =>
        zio.aws.ec2.model.ScheduledInstancesIamInstanceProfile.wrap(value)
      )
    override val imageId: ImageId =
      zio.aws.ec2.model.primitives.ImageId(impl.imageId())
    override val instanceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => value: String)
    override val kernelId: Optional[KernelId] = zio.aws.core.internal
      .optionalFromNullable(impl.kernelId())
      .map(value => zio.aws.ec2.model.primitives.KernelId(value))
    override val keyName: Optional[KeyPairName] = zio.aws.core.internal
      .optionalFromNullable(impl.keyName())
      .map(value => zio.aws.ec2.model.primitives.KeyPairName(value))
    override val monitoring
        : Optional[zio.aws.ec2.model.ScheduledInstancesMonitoring.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoring())
        .map(value =>
          zio.aws.ec2.model.ScheduledInstancesMonitoring.wrap(value)
        )
    override val networkInterfaces: Optional[
      List[zio.aws.ec2.model.ScheduledInstancesNetworkInterface.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInterfaces())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ScheduledInstancesNetworkInterface.wrap(item)
        }.toList
      )
    override val placement
        : Optional[zio.aws.ec2.model.ScheduledInstancesPlacement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placement())
        .map(value => zio.aws.ec2.model.ScheduledInstancesPlacement.wrap(value))
    override val ramdiskId: Optional[RamdiskId] = zio.aws.core.internal
      .optionalFromNullable(impl.ramdiskId())
      .map(value => zio.aws.ec2.model.primitives.RamdiskId(value))
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val subnetId: Optional[SubnetId] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => zio.aws.ec2.model.primitives.SubnetId(value))
    override val userData: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userData())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ScheduledInstancesLaunchSpecification
  ): zio.aws.ec2.model.ScheduledInstancesLaunchSpecification.ReadOnly =
    new Wrapper(impl)
}
