package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TransitGatewayAttachmentId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RejectTransitGatewayPeeringAttachmentRequest(
    transitGatewayAttachmentId: TransitGatewayAttachmentId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RejectTransitGatewayPeeringAttachmentRequest = {
    import RejectTransitGatewayPeeringAttachmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RejectTransitGatewayPeeringAttachmentRequest
      .builder()
      .transitGatewayAttachmentId(
        TransitGatewayAttachmentId.unwrap(
          transitGatewayAttachmentId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.RejectTransitGatewayPeeringAttachmentRequest.ReadOnly =
    zio.aws.ec2.model.RejectTransitGatewayPeeringAttachmentRequest
      .wrap(buildAwsValue())
}
object RejectTransitGatewayPeeringAttachmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RejectTransitGatewayPeeringAttachmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.RejectTransitGatewayPeeringAttachmentRequest =
      zio.aws.ec2.model.RejectTransitGatewayPeeringAttachmentRequest(
        transitGatewayAttachmentId
      )
    def transitGatewayAttachmentId: TransitGatewayAttachmentId
    def getTransitGatewayAttachmentId
        : ZIO[Any, Nothing, TransitGatewayAttachmentId] =
      ZIO.succeed(transitGatewayAttachmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RejectTransitGatewayPeeringAttachmentRequest
  ) extends zio.aws.ec2.model.RejectTransitGatewayPeeringAttachmentRequest.ReadOnly {
    override val transitGatewayAttachmentId: TransitGatewayAttachmentId =
      zio.aws.ec2.model.primitives
        .TransitGatewayAttachmentId(impl.transitGatewayAttachmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RejectTransitGatewayPeeringAttachmentRequest
  ): zio.aws.ec2.model.RejectTransitGatewayPeeringAttachmentRequest.ReadOnly =
    new Wrapper(impl)
}
