package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.PlacementGroupName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PlacementResponse(
    groupName: Optional[PlacementGroupName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PlacementResponse = {
    import PlacementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PlacementResponse
      .builder()
      .optionallyWith(
        groupName.map(value =>
          PlacementGroupName.unwrap(value): java.lang.String
        )
      )(_.groupName)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PlacementResponse.ReadOnly =
    zio.aws.ec2.model.PlacementResponse.wrap(buildAwsValue())
}
object PlacementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PlacementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PlacementResponse =
      zio.aws.ec2.model.PlacementResponse(groupName.map(value => value))
    def groupName: Optional[PlacementGroupName]
    def getGroupName: ZIO[Any, AwsError, PlacementGroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PlacementResponse
  ) extends zio.aws.ec2.model.PlacementResponse.ReadOnly {
    override val groupName: Optional[PlacementGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => zio.aws.ec2.model.primitives.PlacementGroupName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PlacementResponse
  ): zio.aws.ec2.model.PlacementResponse.ReadOnly = new Wrapper(impl)
}
