package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NatGatewayAddress(
    allocationId: Optional[String] = Optional.Absent,
    networkInterfaceId: Optional[String] = Optional.Absent,
    privateIp: Optional[String] = Optional.Absent,
    publicIp: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.NatGatewayAddress = {
    import NatGatewayAddress.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.NatGatewayAddress
      .builder()
      .optionallyWith(allocationId.map(value => value: java.lang.String))(
        _.allocationId
      )
      .optionallyWith(networkInterfaceId.map(value => value: java.lang.String))(
        _.networkInterfaceId
      )
      .optionallyWith(privateIp.map(value => value: java.lang.String))(
        _.privateIp
      )
      .optionallyWith(publicIp.map(value => value: java.lang.String))(
        _.publicIp
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.NatGatewayAddress.ReadOnly =
    zio.aws.ec2.model.NatGatewayAddress.wrap(buildAwsValue())
}
object NatGatewayAddress {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.NatGatewayAddress
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.NatGatewayAddress =
      zio.aws.ec2.model.NatGatewayAddress(
        allocationId.map(value => value),
        networkInterfaceId.map(value => value),
        privateIp.map(value => value),
        publicIp.map(value => value)
      )
    def allocationId: Optional[String]
    def networkInterfaceId: Optional[String]
    def privateIp: Optional[String]
    def publicIp: Optional[String]
    def getAllocationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allocationId", allocationId)
    def getNetworkInterfaceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getPrivateIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateIp", privateIp)
    def getPublicIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicIp", publicIp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.NatGatewayAddress
  ) extends zio.aws.ec2.model.NatGatewayAddress.ReadOnly {
    override val allocationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.allocationId())
      .map(value => value: String)
    override val networkInterfaceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInterfaceId())
      .map(value => value: String)
    override val privateIp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.privateIp())
      .map(value => value: String)
    override val publicIp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.publicIp())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.NatGatewayAddress
  ): zio.aws.ec2.model.NatGatewayAddress.ReadOnly = new Wrapper(impl)
}
