package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait InstanceInterruptionBehavior {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.InstanceInterruptionBehavior
}
object InstanceInterruptionBehavior {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.InstanceInterruptionBehavior
  ): zio.aws.ec2.model.InstanceInterruptionBehavior = value match {
    case software.amazon.awssdk.services.ec2.model.InstanceInterruptionBehavior.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.InstanceInterruptionBehavior.HIBERNATE =>
      val r = hibernate
      r
    case software.amazon.awssdk.services.ec2.model.InstanceInterruptionBehavior.STOP =>
      val r = stop
      r
    case software.amazon.awssdk.services.ec2.model.InstanceInterruptionBehavior.TERMINATE =>
      val r = terminate
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.InstanceInterruptionBehavior {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceInterruptionBehavior =
      software.amazon.awssdk.services.ec2.model.InstanceInterruptionBehavior.UNKNOWN_TO_SDK_VERSION
  }
  case object hibernate extends zio.aws.ec2.model.InstanceInterruptionBehavior {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceInterruptionBehavior =
      software.amazon.awssdk.services.ec2.model.InstanceInterruptionBehavior.HIBERNATE
  }
  case object stop extends zio.aws.ec2.model.InstanceInterruptionBehavior {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceInterruptionBehavior =
      software.amazon.awssdk.services.ec2.model.InstanceInterruptionBehavior.STOP
  }
  case object terminate extends zio.aws.ec2.model.InstanceInterruptionBehavior {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.InstanceInterruptionBehavior =
      software.amazon.awssdk.services.ec2.model.InstanceInterruptionBehavior.TERMINATE
  }
}
