package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Image(
    architecture: Optional[zio.aws.ec2.model.ArchitectureValues] =
      Optional.Absent,
    creationDate: Optional[String] = Optional.Absent,
    imageId: Optional[String] = Optional.Absent,
    imageLocation: Optional[String] = Optional.Absent,
    imageType: Optional[zio.aws.ec2.model.ImageTypeValues] = Optional.Absent,
    publicLaunchPermissions: Optional[Boolean] = Optional.Absent,
    kernelId: Optional[String] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent,
    platform: Optional[zio.aws.ec2.model.PlatformValues] = Optional.Absent,
    platformDetails: Optional[String] = Optional.Absent,
    usageOperation: Optional[String] = Optional.Absent,
    productCodes: Optional[Iterable[zio.aws.ec2.model.ProductCode]] =
      Optional.Absent,
    ramdiskId: Optional[String] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.ImageState] = Optional.Absent,
    blockDeviceMappings: Optional[
      Iterable[zio.aws.ec2.model.BlockDeviceMapping]
    ] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    enaSupport: Optional[Boolean] = Optional.Absent,
    hypervisor: Optional[zio.aws.ec2.model.HypervisorType] = Optional.Absent,
    imageOwnerAlias: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    rootDeviceName: Optional[String] = Optional.Absent,
    rootDeviceType: Optional[zio.aws.ec2.model.DeviceType] = Optional.Absent,
    sriovNetSupport: Optional[String] = Optional.Absent,
    stateReason: Optional[zio.aws.ec2.model.StateReason] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    virtualizationType: Optional[zio.aws.ec2.model.VirtualizationType] =
      Optional.Absent,
    bootMode: Optional[zio.aws.ec2.model.BootModeValues] = Optional.Absent,
    deprecationTime: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.Image = {
    import Image.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Image
      .builder()
      .optionallyWith(architecture.map(value => value.unwrap))(_.architecture)
      .optionallyWith(creationDate.map(value => value: java.lang.String))(
        _.creationDate
      )
      .optionallyWith(imageId.map(value => value: java.lang.String))(_.imageId)
      .optionallyWith(imageLocation.map(value => value: java.lang.String))(
        _.imageLocation
      )
      .optionallyWith(imageType.map(value => value.unwrap))(_.imageType)
      .optionallyWith(
        publicLaunchPermissions.map(value => value: java.lang.Boolean)
      )(_.publicLaunchPermissions)
      .optionallyWith(kernelId.map(value => value: java.lang.String))(
        _.kernelId
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(platformDetails.map(value => value: java.lang.String))(
        _.platformDetails
      )
      .optionallyWith(usageOperation.map(value => value: java.lang.String))(
        _.usageOperation
      )
      .optionallyWith(
        productCodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.productCodes)
      .optionallyWith(ramdiskId.map(value => value: java.lang.String))(
        _.ramdiskId
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappings)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(enaSupport.map(value => value: java.lang.Boolean))(
        _.enaSupport
      )
      .optionallyWith(hypervisor.map(value => value.unwrap))(_.hypervisor)
      .optionallyWith(imageOwnerAlias.map(value => value: java.lang.String))(
        _.imageOwnerAlias
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(rootDeviceName.map(value => value: java.lang.String))(
        _.rootDeviceName
      )
      .optionallyWith(rootDeviceType.map(value => value.unwrap))(
        _.rootDeviceType
      )
      .optionallyWith(sriovNetSupport.map(value => value: java.lang.String))(
        _.sriovNetSupport
      )
      .optionallyWith(stateReason.map(value => value.buildAwsValue()))(
        _.stateReason
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(virtualizationType.map(value => value.unwrap))(
        _.virtualizationType
      )
      .optionallyWith(bootMode.map(value => value.unwrap))(_.bootMode)
      .optionallyWith(deprecationTime.map(value => value: java.lang.String))(
        _.deprecationTime
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Image.ReadOnly =
    zio.aws.ec2.model.Image.wrap(buildAwsValue())
}
object Image {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.Image] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Image = zio.aws.ec2.model.Image(
      architecture.map(value => value),
      creationDate.map(value => value),
      imageId.map(value => value),
      imageLocation.map(value => value),
      imageType.map(value => value),
      publicLaunchPermissions.map(value => value),
      kernelId.map(value => value),
      ownerId.map(value => value),
      platform.map(value => value),
      platformDetails.map(value => value),
      usageOperation.map(value => value),
      productCodes.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      ramdiskId.map(value => value),
      state.map(value => value),
      blockDeviceMappings.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      description.map(value => value),
      enaSupport.map(value => value),
      hypervisor.map(value => value),
      imageOwnerAlias.map(value => value),
      name.map(value => value),
      rootDeviceName.map(value => value),
      rootDeviceType.map(value => value),
      sriovNetSupport.map(value => value),
      stateReason.map(value => value.asEditable),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      virtualizationType.map(value => value),
      bootMode.map(value => value),
      deprecationTime.map(value => value)
    )
    def architecture: Optional[zio.aws.ec2.model.ArchitectureValues]
    def creationDate: Optional[String]
    def imageId: Optional[String]
    def imageLocation: Optional[String]
    def imageType: Optional[zio.aws.ec2.model.ImageTypeValues]
    def publicLaunchPermissions: Optional[Boolean]
    def kernelId: Optional[String]
    def ownerId: Optional[String]
    def platform: Optional[zio.aws.ec2.model.PlatformValues]
    def platformDetails: Optional[String]
    def usageOperation: Optional[String]
    def productCodes: Optional[List[zio.aws.ec2.model.ProductCode.ReadOnly]]
    def ramdiskId: Optional[String]
    def state: Optional[zio.aws.ec2.model.ImageState]
    def blockDeviceMappings
        : Optional[List[zio.aws.ec2.model.BlockDeviceMapping.ReadOnly]]
    def description: Optional[String]
    def enaSupport: Optional[Boolean]
    def hypervisor: Optional[zio.aws.ec2.model.HypervisorType]
    def imageOwnerAlias: Optional[String]
    def name: Optional[String]
    def rootDeviceName: Optional[String]
    def rootDeviceType: Optional[zio.aws.ec2.model.DeviceType]
    def sriovNetSupport: Optional[String]
    def stateReason: Optional[zio.aws.ec2.model.StateReason.ReadOnly]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def virtualizationType: Optional[zio.aws.ec2.model.VirtualizationType]
    def bootMode: Optional[zio.aws.ec2.model.BootModeValues]
    def deprecationTime: Optional[String]
    def getArchitecture
        : ZIO[Any, AwsError, zio.aws.ec2.model.ArchitectureValues] =
      AwsError.unwrapOptionField("architecture", architecture)
    def getCreationDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getImageId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getImageLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageLocation", imageLocation)
    def getImageType: ZIO[Any, AwsError, zio.aws.ec2.model.ImageTypeValues] =
      AwsError.unwrapOptionField("imageType", imageType)
    def getPublicLaunchPermissions: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("publicLaunchPermissions", publicLaunchPermissions)
    def getKernelId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kernelId", kernelId)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getPlatform: ZIO[Any, AwsError, zio.aws.ec2.model.PlatformValues] =
      AwsError.unwrapOptionField("platform", platform)
    def getPlatformDetails: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformDetails", platformDetails)
    def getUsageOperation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("usageOperation", usageOperation)
    def getProductCodes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.ProductCode.ReadOnly]] =
      AwsError.unwrapOptionField("productCodes", productCodes)
    def getRamdiskId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ramdiskId", ramdiskId)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.ImageState] =
      AwsError.unwrapOptionField("state", state)
    def getBlockDeviceMappings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.BlockDeviceMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("blockDeviceMappings", blockDeviceMappings)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getEnaSupport: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enaSupport", enaSupport)
    def getHypervisor: ZIO[Any, AwsError, zio.aws.ec2.model.HypervisorType] =
      AwsError.unwrapOptionField("hypervisor", hypervisor)
    def getImageOwnerAlias: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageOwnerAlias", imageOwnerAlias)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getRootDeviceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("rootDeviceName", rootDeviceName)
    def getRootDeviceType: ZIO[Any, AwsError, zio.aws.ec2.model.DeviceType] =
      AwsError.unwrapOptionField("rootDeviceType", rootDeviceType)
    def getSriovNetSupport: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sriovNetSupport", sriovNetSupport)
    def getStateReason
        : ZIO[Any, AwsError, zio.aws.ec2.model.StateReason.ReadOnly] =
      AwsError.unwrapOptionField("stateReason", stateReason)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVirtualizationType
        : ZIO[Any, AwsError, zio.aws.ec2.model.VirtualizationType] =
      AwsError.unwrapOptionField("virtualizationType", virtualizationType)
    def getBootMode: ZIO[Any, AwsError, zio.aws.ec2.model.BootModeValues] =
      AwsError.unwrapOptionField("bootMode", bootMode)
    def getDeprecationTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deprecationTime", deprecationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Image
  ) extends zio.aws.ec2.model.Image.ReadOnly {
    override val architecture: Optional[zio.aws.ec2.model.ArchitectureValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.architecture())
        .map(value => zio.aws.ec2.model.ArchitectureValues.wrap(value))
    override val creationDate: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => value: String)
    override val imageId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => value: String)
    override val imageLocation: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.imageLocation())
      .map(value => value: String)
    override val imageType: Optional[zio.aws.ec2.model.ImageTypeValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageType())
        .map(value => zio.aws.ec2.model.ImageTypeValues.wrap(value))
    override val publicLaunchPermissions: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publicLaunchPermissions())
        .map(value => value: Boolean)
    override val kernelId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kernelId())
      .map(value => value: String)
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val platform: Optional[zio.aws.ec2.model.PlatformValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platform())
        .map(value => zio.aws.ec2.model.PlatformValues.wrap(value))
    override val platformDetails: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.platformDetails())
      .map(value => value: String)
    override val usageOperation: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.usageOperation())
      .map(value => value: String)
    override val productCodes
        : Optional[List[zio.aws.ec2.model.ProductCode.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productCodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ProductCode.wrap(item)
          }.toList
        )
    override val ramdiskId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ramdiskId())
      .map(value => value: String)
    override val state: Optional[zio.aws.ec2.model.ImageState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.ImageState.wrap(value))
    override val blockDeviceMappings
        : Optional[List[zio.aws.ec2.model.BlockDeviceMapping.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blockDeviceMappings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.BlockDeviceMapping.wrap(item)
          }.toList
        )
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val enaSupport: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enaSupport())
      .map(value => value: Boolean)
    override val hypervisor: Optional[zio.aws.ec2.model.HypervisorType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hypervisor())
        .map(value => zio.aws.ec2.model.HypervisorType.wrap(value))
    override val imageOwnerAlias: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.imageOwnerAlias())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val rootDeviceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.rootDeviceName())
      .map(value => value: String)
    override val rootDeviceType: Optional[zio.aws.ec2.model.DeviceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rootDeviceType())
        .map(value => zio.aws.ec2.model.DeviceType.wrap(value))
    override val sriovNetSupport: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sriovNetSupport())
      .map(value => value: String)
    override val stateReason: Optional[zio.aws.ec2.model.StateReason.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateReason())
        .map(value => zio.aws.ec2.model.StateReason.wrap(value))
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val virtualizationType
        : Optional[zio.aws.ec2.model.VirtualizationType] = zio.aws.core.internal
      .optionalFromNullable(impl.virtualizationType())
      .map(value => zio.aws.ec2.model.VirtualizationType.wrap(value))
    override val bootMode: Optional[zio.aws.ec2.model.BootModeValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bootMode())
        .map(value => zio.aws.ec2.model.BootModeValues.wrap(value))
    override val deprecationTime: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.deprecationTime())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Image
  ): zio.aws.ec2.model.Image.ReadOnly = new Wrapper(impl)
}
