package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.IamInstanceProfileAssociationId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociateIamInstanceProfileRequest(
    associationId: IamInstanceProfileAssociationId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisassociateIamInstanceProfileRequest = {
    import DisassociateIamInstanceProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisassociateIamInstanceProfileRequest
      .builder()
      .associationId(
        IamInstanceProfileAssociationId.unwrap(associationId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisassociateIamInstanceProfileRequest.ReadOnly =
    zio.aws.ec2.model.DisassociateIamInstanceProfileRequest
      .wrap(buildAwsValue())
}
object DisassociateIamInstanceProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisassociateIamInstanceProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisassociateIamInstanceProfileRequest =
      zio.aws.ec2.model.DisassociateIamInstanceProfileRequest(associationId)
    def associationId: IamInstanceProfileAssociationId
    def getAssociationId: ZIO[Any, Nothing, IamInstanceProfileAssociationId] =
      ZIO.succeed(associationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateIamInstanceProfileRequest
  ) extends zio.aws.ec2.model.DisassociateIamInstanceProfileRequest.ReadOnly {
    override val associationId: IamInstanceProfileAssociationId =
      zio.aws.ec2.model.primitives
        .IamInstanceProfileAssociationId(impl.associationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateIamInstanceProfileRequest
  ): zio.aws.ec2.model.DisassociateIamInstanceProfileRequest.ReadOnly =
    new Wrapper(impl)
}
