package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ElasticIpAssociationId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisassociateAddressRequest(
    associationId: Optional[ElasticIpAssociationId] = Optional.Absent,
    publicIp: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisassociateAddressRequest = {
    import DisassociateAddressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisassociateAddressRequest
      .builder()
      .optionallyWith(
        associationId.map(value =>
          ElasticIpAssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(publicIp.map(value => value: java.lang.String))(
        _.publicIp
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DisassociateAddressRequest.ReadOnly =
    zio.aws.ec2.model.DisassociateAddressRequest.wrap(buildAwsValue())
}
object DisassociateAddressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisassociateAddressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisassociateAddressRequest =
      zio.aws.ec2.model.DisassociateAddressRequest(
        associationId.map(value => value),
        publicIp.map(value => value)
      )
    def associationId: Optional[ElasticIpAssociationId]
    def publicIp: Optional[String]
    def getAssociationId: ZIO[Any, AwsError, ElasticIpAssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getPublicIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicIp", publicIp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateAddressRequest
  ) extends zio.aws.ec2.model.DisassociateAddressRequest.ReadOnly {
    override val associationId: Optional[ElasticIpAssociationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationId())
        .map(value =>
          zio.aws.ec2.model.primitives.ElasticIpAssociationId(value)
        )
    override val publicIp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.publicIp())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateAddressRequest
  ): zio.aws.ec2.model.DisassociateAddressRequest.ReadOnly = new Wrapper(impl)
}
