package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisableIpamOrganizationAdminAccountResponse(
    success: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisableIpamOrganizationAdminAccountResponse = {
    import DisableIpamOrganizationAdminAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisableIpamOrganizationAdminAccountResponse
      .builder()
      .optionallyWith(success.map(value => value: java.lang.Boolean))(_.success)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisableIpamOrganizationAdminAccountResponse.ReadOnly =
    zio.aws.ec2.model.DisableIpamOrganizationAdminAccountResponse
      .wrap(buildAwsValue())
}
object DisableIpamOrganizationAdminAccountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisableIpamOrganizationAdminAccountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DisableIpamOrganizationAdminAccountResponse =
      zio.aws.ec2.model.DisableIpamOrganizationAdminAccountResponse(
        success.map(value => value)
      )
    def success: Optional[Boolean]
    def getSuccess: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("success", success)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisableIpamOrganizationAdminAccountResponse
  ) extends zio.aws.ec2.model.DisableIpamOrganizationAdminAccountResponse.ReadOnly {
    override val success: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.success())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisableIpamOrganizationAdminAccountResponse
  ): zio.aws.ec2.model.DisableIpamOrganizationAdminAccountResponse.ReadOnly =
    new Wrapper(impl)
}
