package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{ScheduledInstanceId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeScheduledInstancesRequest(
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    scheduledInstanceIds: Optional[Iterable[ScheduledInstanceId]] =
      Optional.Absent,
    slotStartTimeRange: Optional[zio.aws.ec2.model.SlotStartTimeRangeRequest] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesRequest = {
    import DescribeScheduledInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        scheduledInstanceIds.map(value =>
          value.map { item =>
            ScheduledInstanceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.scheduledInstanceIds)
      .optionallyWith(slotStartTimeRange.map(value => value.buildAwsValue()))(
        _.slotStartTimeRange
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeScheduledInstancesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeScheduledInstancesRequest.wrap(buildAwsValue())
}
object DescribeScheduledInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeScheduledInstancesRequest =
      zio.aws.ec2.model.DescribeScheduledInstancesRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value),
        scheduledInstanceIds.map(value => value),
        slotStartTimeRange.map(value => value.asEditable)
      )
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Optional[Integer]
    def nextToken: Optional[String]
    def scheduledInstanceIds: Optional[List[ScheduledInstanceId]]
    def slotStartTimeRange
        : Optional[zio.aws.ec2.model.SlotStartTimeRangeRequest.ReadOnly]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getScheduledInstanceIds: ZIO[Any, AwsError, List[ScheduledInstanceId]] =
      AwsError.unwrapOptionField("scheduledInstanceIds", scheduledInstanceIds)
    def getSlotStartTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.SlotStartTimeRangeRequest.ReadOnly
    ] = AwsError.unwrapOptionField("slotStartTimeRange", slotStartTimeRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesRequest
  ) extends zio.aws.ec2.model.DescribeScheduledInstancesRequest.ReadOnly {
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val scheduledInstanceIds: Optional[List[ScheduledInstanceId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduledInstanceIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.ScheduledInstanceId(item)
          }.toList
        )
    override val slotStartTimeRange
        : Optional[zio.aws.ec2.model.SlotStartTimeRangeRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.slotStartTimeRange())
        .map(value => zio.aws.ec2.model.SlotStartTimeRangeRequest.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesRequest
  ): zio.aws.ec2.model.DescribeScheduledInstancesRequest.ReadOnly = new Wrapper(
    impl
  )
}
