package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  NextToken,
  NetworkInsightsAccessScopeAnalysisId,
  MillisecondDateTime,
  NetworkInsightsMaxResults,
  NetworkInsightsAccessScopeId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeNetworkInsightsAccessScopeAnalysesRequest(
    networkInsightsAccessScopeAnalysisIds: Optional[
      Iterable[NetworkInsightsAccessScopeAnalysisId]
    ] = Optional.Absent,
    networkInsightsAccessScopeId: Optional[NetworkInsightsAccessScopeId] =
      Optional.Absent,
    analysisStartTimeBegin: Optional[MillisecondDateTime] = Optional.Absent,
    analysisStartTimeEnd: Optional[MillisecondDateTime] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    maxResults: Optional[NetworkInsightsMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest = {
    import DescribeNetworkInsightsAccessScopeAnalysesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest
      .builder()
      .optionallyWith(
        networkInsightsAccessScopeAnalysisIds.map(value =>
          value.map { item =>
            NetworkInsightsAccessScopeAnalysisId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.networkInsightsAccessScopeAnalysisIds)
      .optionallyWith(
        networkInsightsAccessScopeId.map(value =>
          NetworkInsightsAccessScopeId.unwrap(value): java.lang.String
        )
      )(_.networkInsightsAccessScopeId)
      .optionallyWith(
        analysisStartTimeBegin.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.analysisStartTimeBegin)
      .optionallyWith(
        analysisStartTimeEnd.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.analysisStartTimeEnd)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value =>
          NetworkInsightsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest
      .wrap(buildAwsValue())
}
object DescribeNetworkInsightsAccessScopeAnalysesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest =
      zio.aws.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest(
        networkInsightsAccessScopeAnalysisIds.map(value => value),
        networkInsightsAccessScopeId.map(value => value),
        analysisStartTimeBegin.map(value => value),
        analysisStartTimeEnd.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def networkInsightsAccessScopeAnalysisIds
        : Optional[List[NetworkInsightsAccessScopeAnalysisId]]
    def networkInsightsAccessScopeId: Optional[NetworkInsightsAccessScopeId]
    def analysisStartTimeBegin: Optional[MillisecondDateTime]
    def analysisStartTimeEnd: Optional[MillisecondDateTime]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Optional[NetworkInsightsMaxResults]
    def nextToken: Optional[NextToken]
    def getNetworkInsightsAccessScopeAnalysisIds
        : ZIO[Any, AwsError, List[NetworkInsightsAccessScopeAnalysisId]] =
      AwsError.unwrapOptionField(
        "networkInsightsAccessScopeAnalysisIds",
        networkInsightsAccessScopeAnalysisIds
      )
    def getNetworkInsightsAccessScopeId
        : ZIO[Any, AwsError, NetworkInsightsAccessScopeId] =
      AwsError.unwrapOptionField(
        "networkInsightsAccessScopeId",
        networkInsightsAccessScopeId
      )
    def getAnalysisStartTimeBegin: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField(
        "analysisStartTimeBegin",
        analysisStartTimeBegin
      )
    def getAnalysisStartTimeEnd: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("analysisStartTimeEnd", analysisStartTimeEnd)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, NetworkInsightsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest
  ) extends zio.aws.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest.ReadOnly {
    override val networkInsightsAccessScopeAnalysisIds
        : Optional[List[NetworkInsightsAccessScopeAnalysisId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInsightsAccessScopeAnalysisIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives
              .NetworkInsightsAccessScopeAnalysisId(item)
          }.toList
        )
    override val networkInsightsAccessScopeId
        : Optional[NetworkInsightsAccessScopeId] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInsightsAccessScopeId())
      .map(value =>
        zio.aws.ec2.model.primitives.NetworkInsightsAccessScopeId(value)
      )
    override val analysisStartTimeBegin: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.analysisStartTimeBegin())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val analysisStartTimeEnd: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.analysisStartTimeEnd())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[NetworkInsightsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives.NetworkInsightsMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest
  ): zio.aws.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest.ReadOnly =
    new Wrapper(impl)
}
