package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteClientVpnEndpointResponse(
    status: Optional[zio.aws.ec2.model.ClientVpnEndpointStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteClientVpnEndpointResponse = {
    import DeleteClientVpnEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteClientVpnEndpointResponse
      .builder()
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteClientVpnEndpointResponse.ReadOnly =
    zio.aws.ec2.model.DeleteClientVpnEndpointResponse.wrap(buildAwsValue())
}
object DeleteClientVpnEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteClientVpnEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteClientVpnEndpointResponse =
      zio.aws.ec2.model
        .DeleteClientVpnEndpointResponse(status.map(value => value.asEditable))
    def status: Optional[zio.aws.ec2.model.ClientVpnEndpointStatus.ReadOnly]
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ClientVpnEndpointStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteClientVpnEndpointResponse
  ) extends zio.aws.ec2.model.DeleteClientVpnEndpointResponse.ReadOnly {
    override val status
        : Optional[zio.aws.ec2.model.ClientVpnEndpointStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ec2.model.ClientVpnEndpointStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteClientVpnEndpointResponse
  ): zio.aws.ec2.model.DeleteClientVpnEndpointResponse.ReadOnly = new Wrapper(
    impl
  )
}
