package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateInstanceExportTaskRequest(
    description: Optional[String] = Optional.Absent,
    exportToS3Task: zio.aws.ec2.model.ExportToS3TaskSpecification,
    instanceId: InstanceId,
    targetEnvironment: zio.aws.ec2.model.ExportEnvironment,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateInstanceExportTaskRequest = {
    import CreateInstanceExportTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateInstanceExportTaskRequest
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .exportToS3Task(exportToS3Task.buildAwsValue())
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .targetEnvironment(targetEnvironment.unwrap)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateInstanceExportTaskRequest.ReadOnly =
    zio.aws.ec2.model.CreateInstanceExportTaskRequest.wrap(buildAwsValue())
}
object CreateInstanceExportTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateInstanceExportTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateInstanceExportTaskRequest =
      zio.aws.ec2.model.CreateInstanceExportTaskRequest(
        description.map(value => value),
        exportToS3Task.asEditable,
        instanceId,
        targetEnvironment,
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def description: Optional[String]
    def exportToS3Task: zio.aws.ec2.model.ExportToS3TaskSpecification.ReadOnly
    def instanceId: InstanceId
    def targetEnvironment: zio.aws.ec2.model.ExportEnvironment
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getExportToS3Task: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.ExportToS3TaskSpecification.ReadOnly
    ] = ZIO.succeed(exportToS3Task)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getTargetEnvironment
        : ZIO[Any, Nothing, zio.aws.ec2.model.ExportEnvironment] =
      ZIO.succeed(targetEnvironment)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateInstanceExportTaskRequest
  ) extends zio.aws.ec2.model.CreateInstanceExportTaskRequest.ReadOnly {
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val exportToS3Task
        : zio.aws.ec2.model.ExportToS3TaskSpecification.ReadOnly =
      zio.aws.ec2.model.ExportToS3TaskSpecification.wrap(impl.exportToS3Task())
    override val instanceId: InstanceId =
      zio.aws.ec2.model.primitives.InstanceId(impl.instanceId())
    override val targetEnvironment: zio.aws.ec2.model.ExportEnvironment =
      zio.aws.ec2.model.ExportEnvironment.wrap(impl.targetEnvironment())
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateInstanceExportTaskRequest
  ): zio.aws.ec2.model.CreateInstanceExportTaskRequest.ReadOnly = new Wrapper(
    impl
  )
}
