package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ConfirmProductInstanceRequest(
    instanceId: InstanceId,
    productCode: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ConfirmProductInstanceRequest = {
    import ConfirmProductInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ConfirmProductInstanceRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .productCode(productCode: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ConfirmProductInstanceRequest.ReadOnly =
    zio.aws.ec2.model.ConfirmProductInstanceRequest.wrap(buildAwsValue())
}
object ConfirmProductInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ConfirmProductInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ConfirmProductInstanceRequest =
      zio.aws.ec2.model.ConfirmProductInstanceRequest(instanceId, productCode)
    def instanceId: InstanceId
    def productCode: String
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getProductCode: ZIO[Any, Nothing, String] = ZIO.succeed(productCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ConfirmProductInstanceRequest
  ) extends zio.aws.ec2.model.ConfirmProductInstanceRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.ec2.model.primitives.InstanceId(impl.instanceId())
    override val productCode: String = impl.productCode(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ConfirmProductInstanceRequest
  ): zio.aws.ec2.model.ConfirmProductInstanceRequest.ReadOnly = new Wrapper(
    impl
  )
}
