package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{VpcId, InstanceId, SecurityGroupId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AttachClassicLinkVpcRequest(
    groups: Iterable[SecurityGroupId],
    instanceId: InstanceId,
    vpcId: VpcId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AttachClassicLinkVpcRequest = {
    import AttachClassicLinkVpcRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AttachClassicLinkVpcRequest
      .builder()
      .groups(groups.map { item =>
        SecurityGroupId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AttachClassicLinkVpcRequest.ReadOnly =
    zio.aws.ec2.model.AttachClassicLinkVpcRequest.wrap(buildAwsValue())
}
object AttachClassicLinkVpcRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AttachClassicLinkVpcRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AttachClassicLinkVpcRequest =
      zio.aws.ec2.model.AttachClassicLinkVpcRequest(groups, instanceId, vpcId)
    def groups: List[SecurityGroupId]
    def instanceId: InstanceId
    def vpcId: VpcId
    def getGroups: ZIO[Any, Nothing, List[SecurityGroupId]] =
      ZIO.succeed(groups)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AttachClassicLinkVpcRequest
  ) extends zio.aws.ec2.model.AttachClassicLinkVpcRequest.ReadOnly {
    override val groups: List[SecurityGroupId] = impl
      .groups()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.SecurityGroupId(item)
      }
      .toList
    override val instanceId: InstanceId =
      zio.aws.ec2.model.primitives.InstanceId(impl.instanceId())
    override val vpcId: VpcId = zio.aws.ec2.model.primitives.VpcId(impl.vpcId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AttachClassicLinkVpcRequest
  ): zio.aws.ec2.model.AttachClassicLinkVpcRequest.ReadOnly = new Wrapper(impl)
}
