package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpnConnectionDeviceType(
    vpnConnectionDeviceTypeId: Optional[String] = Optional.Absent,
    vendor: Optional[String] = Optional.Absent,
    platform: Optional[String] = Optional.Absent,
    software: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : _root_.software.amazon.awssdk.services.ec2.model.VpnConnectionDeviceType = {
    import VpnConnectionDeviceType.zioAwsBuilderHelper.BuilderOps
    _root_.software.amazon.awssdk.services.ec2.model.VpnConnectionDeviceType
      .builder()
      .optionallyWith(
        vpnConnectionDeviceTypeId.map(value => value: java.lang.String)
      )(_.vpnConnectionDeviceTypeId)
      .optionallyWith(vendor.map(value => value: java.lang.String))(_.vendor)
      .optionallyWith(platform.map(value => value: java.lang.String))(
        _.platform
      )
      .optionallyWith(software.map(value => value: java.lang.String))(
        _.software
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VpnConnectionDeviceType.ReadOnly =
    zio.aws.ec2.model.VpnConnectionDeviceType.wrap(buildAwsValue())
}
object VpnConnectionDeviceType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    _root_.software.amazon.awssdk.services.ec2.model.VpnConnectionDeviceType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VpnConnectionDeviceType =
      zio.aws.ec2.model.VpnConnectionDeviceType(
        vpnConnectionDeviceTypeId.map(value => value),
        vendor.map(value => value),
        platform.map(value => value),
        software.map(value => value)
      )
    def vpnConnectionDeviceTypeId: Optional[String]
    def vendor: Optional[String]
    def platform: Optional[String]
    def software: Optional[String]
    def getVpnConnectionDeviceTypeId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("vpnConnectionDeviceTypeId", vpnConnectionDeviceTypeId)
    def getVendor: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vendor", vendor)
    def getPlatform: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platform", platform)
    def getSoftware: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("software", software)
  }
  private final class Wrapper(
      impl: _root_.software.amazon.awssdk.services.ec2.model.VpnConnectionDeviceType
  ) extends zio.aws.ec2.model.VpnConnectionDeviceType.ReadOnly {
    override val vpnConnectionDeviceTypeId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpnConnectionDeviceTypeId())
        .map(value => value: String)
    override val vendor: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vendor())
      .map(value => value: String)
    override val platform: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.platform())
      .map(value => value: String)
    override val software: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.software())
      .map(value => value: String)
  }
  def wrap(
      impl: _root_.software.amazon.awssdk.services.ec2.model.VpnConnectionDeviceType
  ): zio.aws.ec2.model.VpnConnectionDeviceType.ReadOnly = new Wrapper(impl)
}
