package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VolumeStatusItem(
    actions: Optional[Iterable[zio.aws.ec2.model.VolumeStatusAction]] =
      Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent,
    outpostArn: Optional[String] = Optional.Absent,
    events: Optional[Iterable[zio.aws.ec2.model.VolumeStatusEvent]] =
      Optional.Absent,
    volumeId: Optional[String] = Optional.Absent,
    volumeStatus: Optional[zio.aws.ec2.model.VolumeStatusInfo] =
      Optional.Absent,
    attachmentStatuses: Optional[
      Iterable[zio.aws.ec2.model.VolumeStatusAttachmentStatus]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VolumeStatusItem = {
    import VolumeStatusItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VolumeStatusItem
      .builder()
      .optionallyWith(
        actions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actions)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(outpostArn.map(value => value: java.lang.String))(
        _.outpostArn
      )
      .optionallyWith(
        events.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.events)
      .optionallyWith(volumeId.map(value => value: java.lang.String))(
        _.volumeId
      )
      .optionallyWith(volumeStatus.map(value => value.buildAwsValue()))(
        _.volumeStatus
      )
      .optionallyWith(
        attachmentStatuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachmentStatuses)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VolumeStatusItem.ReadOnly =
    zio.aws.ec2.model.VolumeStatusItem.wrap(buildAwsValue())
}
object VolumeStatusItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VolumeStatusItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VolumeStatusItem =
      zio.aws.ec2.model.VolumeStatusItem(
        actions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        availabilityZone.map(value => value),
        outpostArn.map(value => value),
        events.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        volumeId.map(value => value),
        volumeStatus.map(value => value.asEditable),
        attachmentStatuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def actions: Optional[List[zio.aws.ec2.model.VolumeStatusAction.ReadOnly]]
    def availabilityZone: Optional[String]
    def outpostArn: Optional[String]
    def events: Optional[List[zio.aws.ec2.model.VolumeStatusEvent.ReadOnly]]
    def volumeId: Optional[String]
    def volumeStatus: Optional[zio.aws.ec2.model.VolumeStatusInfo.ReadOnly]
    def attachmentStatuses: Optional[
      List[zio.aws.ec2.model.VolumeStatusAttachmentStatus.ReadOnly]
    ]
    def getActions: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.VolumeStatusAction.ReadOnly
    ]] = AwsError.unwrapOptionField("actions", actions)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getEvents: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.VolumeStatusEvent.ReadOnly
    ]] = AwsError.unwrapOptionField("events", events)
    def getVolumeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("volumeId", volumeId)
    def getVolumeStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.VolumeStatusInfo.ReadOnly] =
      AwsError.unwrapOptionField("volumeStatus", volumeStatus)
    def getAttachmentStatuses: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.VolumeStatusAttachmentStatus.ReadOnly
    ]] = AwsError.unwrapOptionField("attachmentStatuses", attachmentStatuses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VolumeStatusItem
  ) extends zio.aws.ec2.model.VolumeStatusItem.ReadOnly {
    override val actions
        : Optional[List[zio.aws.ec2.model.VolumeStatusAction.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.VolumeStatusAction.wrap(item)
          }.toList
        )
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val outpostArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.outpostArn())
      .map(value => value: String)
    override val events
        : Optional[List[zio.aws.ec2.model.VolumeStatusEvent.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.events())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.VolumeStatusEvent.wrap(item)
          }.toList
        )
    override val volumeId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeId())
      .map(value => value: String)
    override val volumeStatus
        : Optional[zio.aws.ec2.model.VolumeStatusInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeStatus())
        .map(value => zio.aws.ec2.model.VolumeStatusInfo.wrap(value))
    override val attachmentStatuses: Optional[
      List[zio.aws.ec2.model.VolumeStatusAttachmentStatus.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attachmentStatuses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.VolumeStatusAttachmentStatus.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VolumeStatusItem
  ): zio.aws.ec2.model.VolumeStatusItem.ReadOnly = new Wrapper(impl)
}
