package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait TransitGatewayPropagationState {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.TransitGatewayPropagationState
}
object TransitGatewayPropagationState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.TransitGatewayPropagationState
  ): zio.aws.ec2.model.TransitGatewayPropagationState = value match {
    case software.amazon.awssdk.services.ec2.model.TransitGatewayPropagationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayPropagationState.ENABLING =>
      val r = enabling
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayPropagationState.ENABLED =>
      val r = enabled
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayPropagationState.DISABLING =>
      val r = disabling
      r
    case software.amazon.awssdk.services.ec2.model.TransitGatewayPropagationState.DISABLED =>
      val r = disabled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.TransitGatewayPropagationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayPropagationState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayPropagationState.UNKNOWN_TO_SDK_VERSION
  }
  case object enabling
      extends zio.aws.ec2.model.TransitGatewayPropagationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayPropagationState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayPropagationState.ENABLING
  }
  case object enabled extends zio.aws.ec2.model.TransitGatewayPropagationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayPropagationState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayPropagationState.ENABLED
  }
  case object disabling
      extends zio.aws.ec2.model.TransitGatewayPropagationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayPropagationState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayPropagationState.DISABLING
  }
  case object disabled
      extends zio.aws.ec2.model.TransitGatewayPropagationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TransitGatewayPropagationState =
      software.amazon.awssdk.services.ec2.model.TransitGatewayPropagationState.DISABLED
  }
}
