package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait State {
  def unwrap: software.amazon.awssdk.services.ec2.model.State
}
object State {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.State
  ): zio.aws.ec2.model.State = value match {
    case software.amazon.awssdk.services.ec2.model.State.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.State.PENDING_ACCEPTANCE =>
      val r = PendingAcceptance
      r
    case software.amazon.awssdk.services.ec2.model.State.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.ec2.model.State.AVAILABLE =>
      val r = Available
      r
    case software.amazon.awssdk.services.ec2.model.State.DELETING =>
      val r = Deleting
      r
    case software.amazon.awssdk.services.ec2.model.State.DELETED =>
      val r = Deleted
      r
    case software.amazon.awssdk.services.ec2.model.State.REJECTED =>
      val r = Rejected
      r
    case software.amazon.awssdk.services.ec2.model.State.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.ec2.model.State.EXPIRED =>
      val r = Expired
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.State {
    override def unwrap: software.amazon.awssdk.services.ec2.model.State =
      software.amazon.awssdk.services.ec2.model.State.UNKNOWN_TO_SDK_VERSION
  }
  case object PendingAcceptance extends zio.aws.ec2.model.State {
    override def unwrap: software.amazon.awssdk.services.ec2.model.State =
      software.amazon.awssdk.services.ec2.model.State.PENDING_ACCEPTANCE
  }
  case object Pending extends zio.aws.ec2.model.State {
    override def unwrap: software.amazon.awssdk.services.ec2.model.State =
      software.amazon.awssdk.services.ec2.model.State.PENDING
  }
  case object Available extends zio.aws.ec2.model.State {
    override def unwrap: software.amazon.awssdk.services.ec2.model.State =
      software.amazon.awssdk.services.ec2.model.State.AVAILABLE
  }
  case object Deleting extends zio.aws.ec2.model.State {
    override def unwrap: software.amazon.awssdk.services.ec2.model.State =
      software.amazon.awssdk.services.ec2.model.State.DELETING
  }
  case object Deleted extends zio.aws.ec2.model.State {
    override def unwrap: software.amazon.awssdk.services.ec2.model.State =
      software.amazon.awssdk.services.ec2.model.State.DELETED
  }
  case object Rejected extends zio.aws.ec2.model.State {
    override def unwrap: software.amazon.awssdk.services.ec2.model.State =
      software.amazon.awssdk.services.ec2.model.State.REJECTED
  }
  case object Failed extends zio.aws.ec2.model.State {
    override def unwrap: software.amazon.awssdk.services.ec2.model.State =
      software.amazon.awssdk.services.ec2.model.State.FAILED
  }
  case object Expired extends zio.aws.ec2.model.State {
    override def unwrap: software.amazon.awssdk.services.ec2.model.State =
      software.amazon.awssdk.services.ec2.model.State.EXPIRED
  }
}
