package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ProductCode(
    productCodeId: Optional[String] = Optional.Absent,
    productCodeType: Optional[zio.aws.ec2.model.ProductCodeValues] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.ProductCode = {
    import ProductCode.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ProductCode
      .builder()
      .optionallyWith(productCodeId.map(value => value: java.lang.String))(
        _.productCodeId
      )
      .optionallyWith(productCodeType.map(value => value.unwrap))(
        _.productCodeType
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ProductCode.ReadOnly =
    zio.aws.ec2.model.ProductCode.wrap(buildAwsValue())
}
object ProductCode {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.ProductCode] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ProductCode =
      zio.aws.ec2.model.ProductCode(
        productCodeId.map(value => value),
        productCodeType.map(value => value)
      )
    def productCodeId: Optional[String]
    def productCodeType: Optional[zio.aws.ec2.model.ProductCodeValues]
    def getProductCodeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("productCodeId", productCodeId)
    def getProductCodeType
        : ZIO[Any, AwsError, zio.aws.ec2.model.ProductCodeValues] =
      AwsError.unwrapOptionField("productCodeType", productCodeType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ProductCode
  ) extends zio.aws.ec2.model.ProductCode.ReadOnly {
    override val productCodeId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.productCodeId())
      .map(value => value: String)
    override val productCodeType
        : Optional[zio.aws.ec2.model.ProductCodeValues] = zio.aws.core.internal
      .optionalFromNullable(impl.productCodeType())
      .map(value => zio.aws.ec2.model.ProductCodeValues.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ProductCode
  ): zio.aws.ec2.model.ProductCode.ReadOnly = new Wrapper(impl)
}
