package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PrincipalIdFormat(
    arn: Optional[String] = Optional.Absent,
    statuses: Optional[Iterable[zio.aws.ec2.model.IdFormat]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PrincipalIdFormat = {
    import PrincipalIdFormat.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PrincipalIdFormat
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        statuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statuses)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PrincipalIdFormat.ReadOnly =
    zio.aws.ec2.model.PrincipalIdFormat.wrap(buildAwsValue())
}
object PrincipalIdFormat {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PrincipalIdFormat
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PrincipalIdFormat =
      zio.aws.ec2.model.PrincipalIdFormat(
        arn.map(value => value),
        statuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def arn: Optional[String]
    def statuses: Optional[List[zio.aws.ec2.model.IdFormat.ReadOnly]]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getStatuses
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.IdFormat.ReadOnly]] =
      AwsError.unwrapOptionField("statuses", statuses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PrincipalIdFormat
  ) extends zio.aws.ec2.model.PrincipalIdFormat.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
    override val statuses: Optional[List[zio.aws.ec2.model.IdFormat.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statuses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.IdFormat.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PrincipalIdFormat
  ): zio.aws.ec2.model.PrincipalIdFormat.ReadOnly = new Wrapper(impl)
}
