package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TransitGatewayRouteTableId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyTransitGatewayOptions(
    addTransitGatewayCidrBlocks: Optional[Iterable[String]] = Optional.Absent,
    removeTransitGatewayCidrBlocks: Optional[Iterable[String]] =
      Optional.Absent,
    vpnEcmpSupport: Optional[zio.aws.ec2.model.VpnEcmpSupportValue] =
      Optional.Absent,
    dnsSupport: Optional[zio.aws.ec2.model.DnsSupportValue] = Optional.Absent,
    autoAcceptSharedAttachments: Optional[
      zio.aws.ec2.model.AutoAcceptSharedAttachmentsValue
    ] = Optional.Absent,
    defaultRouteTableAssociation: Optional[
      zio.aws.ec2.model.DefaultRouteTableAssociationValue
    ] = Optional.Absent,
    associationDefaultRouteTableId: Optional[TransitGatewayRouteTableId] =
      Optional.Absent,
    defaultRouteTablePropagation: Optional[
      zio.aws.ec2.model.DefaultRouteTablePropagationValue
    ] = Optional.Absent,
    propagationDefaultRouteTableId: Optional[TransitGatewayRouteTableId] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayOptions = {
    import ModifyTransitGatewayOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayOptions
      .builder()
      .optionallyWith(
        addTransitGatewayCidrBlocks.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.addTransitGatewayCidrBlocks)
      .optionallyWith(
        removeTransitGatewayCidrBlocks.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.removeTransitGatewayCidrBlocks)
      .optionallyWith(vpnEcmpSupport.map(value => value.unwrap))(
        _.vpnEcmpSupport
      )
      .optionallyWith(dnsSupport.map(value => value.unwrap))(_.dnsSupport)
      .optionallyWith(autoAcceptSharedAttachments.map(value => value.unwrap))(
        _.autoAcceptSharedAttachments
      )
      .optionallyWith(defaultRouteTableAssociation.map(value => value.unwrap))(
        _.defaultRouteTableAssociation
      )
      .optionallyWith(
        associationDefaultRouteTableId.map(value =>
          TransitGatewayRouteTableId.unwrap(value): java.lang.String
        )
      )(_.associationDefaultRouteTableId)
      .optionallyWith(defaultRouteTablePropagation.map(value => value.unwrap))(
        _.defaultRouteTablePropagation
      )
      .optionallyWith(
        propagationDefaultRouteTableId.map(value =>
          TransitGatewayRouteTableId.unwrap(value): java.lang.String
        )
      )(_.propagationDefaultRouteTableId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyTransitGatewayOptions.ReadOnly =
    zio.aws.ec2.model.ModifyTransitGatewayOptions.wrap(buildAwsValue())
}
object ModifyTransitGatewayOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyTransitGatewayOptions =
      zio.aws.ec2.model.ModifyTransitGatewayOptions(
        addTransitGatewayCidrBlocks.map(value => value),
        removeTransitGatewayCidrBlocks.map(value => value),
        vpnEcmpSupport.map(value => value),
        dnsSupport.map(value => value),
        autoAcceptSharedAttachments.map(value => value),
        defaultRouteTableAssociation.map(value => value),
        associationDefaultRouteTableId.map(value => value),
        defaultRouteTablePropagation.map(value => value),
        propagationDefaultRouteTableId.map(value => value)
      )
    def addTransitGatewayCidrBlocks: Optional[List[String]]
    def removeTransitGatewayCidrBlocks: Optional[List[String]]
    def vpnEcmpSupport: Optional[zio.aws.ec2.model.VpnEcmpSupportValue]
    def dnsSupport: Optional[zio.aws.ec2.model.DnsSupportValue]
    def autoAcceptSharedAttachments
        : Optional[zio.aws.ec2.model.AutoAcceptSharedAttachmentsValue]
    def defaultRouteTableAssociation
        : Optional[zio.aws.ec2.model.DefaultRouteTableAssociationValue]
    def associationDefaultRouteTableId: Optional[TransitGatewayRouteTableId]
    def defaultRouteTablePropagation
        : Optional[zio.aws.ec2.model.DefaultRouteTablePropagationValue]
    def propagationDefaultRouteTableId: Optional[TransitGatewayRouteTableId]
    def getAddTransitGatewayCidrBlocks: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "addTransitGatewayCidrBlocks",
        addTransitGatewayCidrBlocks
      )
    def getRemoveTransitGatewayCidrBlocks: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "removeTransitGatewayCidrBlocks",
        removeTransitGatewayCidrBlocks
      )
    def getVpnEcmpSupport
        : ZIO[Any, AwsError, zio.aws.ec2.model.VpnEcmpSupportValue] =
      AwsError.unwrapOptionField("vpnEcmpSupport", vpnEcmpSupport)
    def getDnsSupport: ZIO[Any, AwsError, zio.aws.ec2.model.DnsSupportValue] =
      AwsError.unwrapOptionField("dnsSupport", dnsSupport)
    def getAutoAcceptSharedAttachments: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.AutoAcceptSharedAttachmentsValue
    ] = AwsError.unwrapOptionField(
      "autoAcceptSharedAttachments",
      autoAcceptSharedAttachments
    )
    def getDefaultRouteTableAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.DefaultRouteTableAssociationValue
    ] = AwsError.unwrapOptionField(
      "defaultRouteTableAssociation",
      defaultRouteTableAssociation
    )
    def getAssociationDefaultRouteTableId
        : ZIO[Any, AwsError, TransitGatewayRouteTableId] =
      AwsError.unwrapOptionField(
        "associationDefaultRouteTableId",
        associationDefaultRouteTableId
      )
    def getDefaultRouteTablePropagation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.DefaultRouteTablePropagationValue
    ] = AwsError.unwrapOptionField(
      "defaultRouteTablePropagation",
      defaultRouteTablePropagation
    )
    def getPropagationDefaultRouteTableId
        : ZIO[Any, AwsError, TransitGatewayRouteTableId] =
      AwsError.unwrapOptionField(
        "propagationDefaultRouteTableId",
        propagationDefaultRouteTableId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayOptions
  ) extends zio.aws.ec2.model.ModifyTransitGatewayOptions.ReadOnly {
    override val addTransitGatewayCidrBlocks: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addTransitGatewayCidrBlocks())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val removeTransitGatewayCidrBlocks: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeTransitGatewayCidrBlocks())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val vpnEcmpSupport
        : Optional[zio.aws.ec2.model.VpnEcmpSupportValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpnEcmpSupport())
        .map(value => zio.aws.ec2.model.VpnEcmpSupportValue.wrap(value))
    override val dnsSupport: Optional[zio.aws.ec2.model.DnsSupportValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dnsSupport())
        .map(value => zio.aws.ec2.model.DnsSupportValue.wrap(value))
    override val autoAcceptSharedAttachments
        : Optional[zio.aws.ec2.model.AutoAcceptSharedAttachmentsValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoAcceptSharedAttachments())
        .map(value =>
          zio.aws.ec2.model.AutoAcceptSharedAttachmentsValue.wrap(value)
        )
    override val defaultRouteTableAssociation
        : Optional[zio.aws.ec2.model.DefaultRouteTableAssociationValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultRouteTableAssociation())
        .map(value =>
          zio.aws.ec2.model.DefaultRouteTableAssociationValue.wrap(value)
        )
    override val associationDefaultRouteTableId
        : Optional[TransitGatewayRouteTableId] = zio.aws.core.internal
      .optionalFromNullable(impl.associationDefaultRouteTableId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayRouteTableId(value)
      )
    override val defaultRouteTablePropagation
        : Optional[zio.aws.ec2.model.DefaultRouteTablePropagationValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultRouteTablePropagation())
        .map(value =>
          zio.aws.ec2.model.DefaultRouteTablePropagationValue.wrap(value)
        )
    override val propagationDefaultRouteTableId
        : Optional[TransitGatewayRouteTableId] = zio.aws.core.internal
      .optionalFromNullable(impl.propagationDefaultRouteTableId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayRouteTableId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayOptions
  ): zio.aws.ec2.model.ModifyTransitGatewayOptions.ReadOnly = new Wrapper(impl)
}
