package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceBlockDeviceMapping(
    deviceName: Optional[String] = Optional.Absent,
    ebs: Optional[zio.aws.ec2.model.EbsInstanceBlockDevice] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMapping = {
    import InstanceBlockDeviceMapping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMapping
      .builder()
      .optionallyWith(deviceName.map(value => value: java.lang.String))(
        _.deviceName
      )
      .optionallyWith(ebs.map(value => value.buildAwsValue()))(_.ebs)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceBlockDeviceMapping.ReadOnly =
    zio.aws.ec2.model.InstanceBlockDeviceMapping.wrap(buildAwsValue())
}
object InstanceBlockDeviceMapping {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMapping
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceBlockDeviceMapping =
      zio.aws.ec2.model.InstanceBlockDeviceMapping(
        deviceName.map(value => value),
        ebs.map(value => value.asEditable)
      )
    def deviceName: Optional[String]
    def ebs: Optional[zio.aws.ec2.model.EbsInstanceBlockDevice.ReadOnly]
    def getDeviceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deviceName", deviceName)
    def getEbs: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.EbsInstanceBlockDevice.ReadOnly
    ] = AwsError.unwrapOptionField("ebs", ebs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMapping
  ) extends zio.aws.ec2.model.InstanceBlockDeviceMapping.ReadOnly {
    override val deviceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceName())
      .map(value => value: String)
    override val ebs
        : Optional[zio.aws.ec2.model.EbsInstanceBlockDevice.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ebs())
        .map(value => zio.aws.ec2.model.EbsInstanceBlockDevice.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMapping
  ): zio.aws.ec2.model.InstanceBlockDeviceMapping.ReadOnly = new Wrapper(impl)
}
