package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class HostProperties(
    cores: Optional[Integer] = Optional.Absent,
    instanceType: Optional[String] = Optional.Absent,
    instanceFamily: Optional[String] = Optional.Absent,
    sockets: Optional[Integer] = Optional.Absent,
    totalVCpus: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.HostProperties = {
    import HostProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.HostProperties
      .builder()
      .optionallyWith(cores.map(value => value: java.lang.Integer))(_.cores)
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(instanceFamily.map(value => value: java.lang.String))(
        _.instanceFamily
      )
      .optionallyWith(sockets.map(value => value: java.lang.Integer))(_.sockets)
      .optionallyWith(totalVCpus.map(value => value: java.lang.Integer))(
        _.totalVCpus
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.HostProperties.ReadOnly =
    zio.aws.ec2.model.HostProperties.wrap(buildAwsValue())
}
object HostProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.HostProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.HostProperties =
      zio.aws.ec2.model.HostProperties(
        cores.map(value => value),
        instanceType.map(value => value),
        instanceFamily.map(value => value),
        sockets.map(value => value),
        totalVCpus.map(value => value)
      )
    def cores: Optional[Integer]
    def instanceType: Optional[String]
    def instanceFamily: Optional[String]
    def sockets: Optional[Integer]
    def totalVCpus: Optional[Integer]
    def getCores: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("cores", cores)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getInstanceFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceFamily", instanceFamily)
    def getSockets: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sockets", sockets)
    def getTotalVCpus: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalVCpus", totalVCpus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.HostProperties
  ) extends zio.aws.ec2.model.HostProperties.ReadOnly {
    override val cores: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.cores())
      .map(value => value: Integer)
    override val instanceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => value: String)
    override val instanceFamily: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceFamily())
      .map(value => value: String)
    override val sockets: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.sockets())
      .map(value => value: Integer)
    override val totalVCpus: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.totalVCpus())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.HostProperties
  ): zio.aws.ec2.model.HostProperties.ReadOnly = new Wrapper(impl)
}
