package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NetworkInsightsAccessScopeAnalysisId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetNetworkInsightsAccessScopeAnalysisFindingsResponse(
    networkInsightsAccessScopeAnalysisId: Optional[
      NetworkInsightsAccessScopeAnalysisId
    ] = Optional.Absent,
    analysisStatus: Optional[zio.aws.ec2.model.AnalysisStatus] =
      Optional.Absent,
    analysisFindings: Optional[
      Iterable[zio.aws.ec2.model.AccessScopeAnalysisFinding]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsResponse = {
    import GetNetworkInsightsAccessScopeAnalysisFindingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsResponse
      .builder()
      .optionallyWith(
        networkInsightsAccessScopeAnalysisId.map(value =>
          NetworkInsightsAccessScopeAnalysisId.unwrap(value): java.lang.String
        )
      )(_.networkInsightsAccessScopeAnalysisId)
      .optionallyWith(analysisStatus.map(value => value.unwrap))(
        _.analysisStatus
      )
      .optionallyWith(
        analysisFindings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.analysisFindings)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsResponse.ReadOnly =
    zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsResponse
      .wrap(buildAwsValue())
}
object GetNetworkInsightsAccessScopeAnalysisFindingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsResponse =
      zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsResponse(
        networkInsightsAccessScopeAnalysisId.map(value => value),
        analysisStatus.map(value => value),
        analysisFindings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def networkInsightsAccessScopeAnalysisId
        : Optional[NetworkInsightsAccessScopeAnalysisId]
    def analysisStatus: Optional[zio.aws.ec2.model.AnalysisStatus]
    def analysisFindings
        : Optional[List[zio.aws.ec2.model.AccessScopeAnalysisFinding.ReadOnly]]
    def nextToken: Optional[String]
    def getNetworkInsightsAccessScopeAnalysisId
        : ZIO[Any, AwsError, NetworkInsightsAccessScopeAnalysisId] =
      AwsError.unwrapOptionField(
        "networkInsightsAccessScopeAnalysisId",
        networkInsightsAccessScopeAnalysisId
      )
    def getAnalysisStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisStatus] =
      AwsError.unwrapOptionField("analysisStatus", analysisStatus)
    def getAnalysisFindings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AccessScopeAnalysisFinding.ReadOnly
    ]] = AwsError.unwrapOptionField("analysisFindings", analysisFindings)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsResponse
  ) extends zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsResponse.ReadOnly {
    override val networkInsightsAccessScopeAnalysisId
        : Optional[NetworkInsightsAccessScopeAnalysisId] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInsightsAccessScopeAnalysisId())
      .map(value =>
        zio.aws.ec2.model.primitives.NetworkInsightsAccessScopeAnalysisId(value)
      )
    override val analysisStatus: Optional[zio.aws.ec2.model.AnalysisStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.analysisStatus())
        .map(value => zio.aws.ec2.model.AnalysisStatus.wrap(value))
    override val analysisFindings: Optional[
      List[zio.aws.ec2.model.AccessScopeAnalysisFinding.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.analysisFindings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.AccessScopeAnalysisFinding.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsResponse
  ): zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsResponse.ReadOnly =
    new Wrapper(impl)
}
