package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  FpgaDeviceCount,
  FpgaDeviceManufacturerName,
  FpgaDeviceName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class FpgaDeviceInfo(
    name: Optional[FpgaDeviceName] = Optional.Absent,
    manufacturer: Optional[FpgaDeviceManufacturerName] = Optional.Absent,
    count: Optional[FpgaDeviceCount] = Optional.Absent,
    memoryInfo: Optional[zio.aws.ec2.model.FpgaDeviceMemoryInfo] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.FpgaDeviceInfo = {
    import FpgaDeviceInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FpgaDeviceInfo
      .builder()
      .optionallyWith(
        name.map(value => FpgaDeviceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        manufacturer.map(value =>
          FpgaDeviceManufacturerName.unwrap(value): java.lang.String
        )
      )(_.manufacturer)
      .optionallyWith(
        count.map(value => FpgaDeviceCount.unwrap(value): Integer)
      )(_.count)
      .optionallyWith(memoryInfo.map(value => value.buildAwsValue()))(
        _.memoryInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.FpgaDeviceInfo.ReadOnly =
    zio.aws.ec2.model.FpgaDeviceInfo.wrap(buildAwsValue())
}
object FpgaDeviceInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.FpgaDeviceInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.FpgaDeviceInfo =
      zio.aws.ec2.model.FpgaDeviceInfo(
        name.map(value => value),
        manufacturer.map(value => value),
        count.map(value => value),
        memoryInfo.map(value => value.asEditable)
      )
    def name: Optional[FpgaDeviceName]
    def manufacturer: Optional[FpgaDeviceManufacturerName]
    def count: Optional[FpgaDeviceCount]
    def memoryInfo: Optional[zio.aws.ec2.model.FpgaDeviceMemoryInfo.ReadOnly]
    def getName: ZIO[Any, AwsError, FpgaDeviceName] =
      AwsError.unwrapOptionField("name", name)
    def getManufacturer: ZIO[Any, AwsError, FpgaDeviceManufacturerName] =
      AwsError.unwrapOptionField("manufacturer", manufacturer)
    def getCount: ZIO[Any, AwsError, FpgaDeviceCount] =
      AwsError.unwrapOptionField("count", count)
    def getMemoryInfo
        : ZIO[Any, AwsError, zio.aws.ec2.model.FpgaDeviceMemoryInfo.ReadOnly] =
      AwsError.unwrapOptionField("memoryInfo", memoryInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FpgaDeviceInfo
  ) extends zio.aws.ec2.model.FpgaDeviceInfo.ReadOnly {
    override val name: Optional[FpgaDeviceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ec2.model.primitives.FpgaDeviceName(value))
    override val manufacturer: Optional[FpgaDeviceManufacturerName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manufacturer())
        .map(value =>
          zio.aws.ec2.model.primitives.FpgaDeviceManufacturerName(value)
        )
    override val count: Optional[FpgaDeviceCount] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => zio.aws.ec2.model.primitives.FpgaDeviceCount(value))
    override val memoryInfo
        : Optional[zio.aws.ec2.model.FpgaDeviceMemoryInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.memoryInfo())
        .map(value => zio.aws.ec2.model.FpgaDeviceMemoryInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FpgaDeviceInfo
  ): zio.aws.ec2.model.FpgaDeviceInfo.ReadOnly = new Wrapper(impl)
}
