package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{MillisecondDateTime, Integer, ImageId}
import scala.jdk.CollectionConverters._
final case class DisableFastLaunchResponse(
    imageId: Optional[ImageId] = Optional.Absent,
    resourceType: Optional[zio.aws.ec2.model.FastLaunchResourceType] =
      Optional.Absent,
    snapshotConfiguration: Optional[
      zio.aws.ec2.model.FastLaunchSnapshotConfigurationResponse
    ] = Optional.Absent,
    launchTemplate: Optional[
      zio.aws.ec2.model.FastLaunchLaunchTemplateSpecificationResponse
    ] = Optional.Absent,
    maxParallelLaunches: Optional[Integer] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.FastLaunchStateCode] = Optional.Absent,
    stateTransitionReason: Optional[String] = Optional.Absent,
    stateTransitionTime: Optional[MillisecondDateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisableFastLaunchResponse = {
    import DisableFastLaunchResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisableFastLaunchResponse
      .builder()
      .optionallyWith(
        imageId.map(value => ImageId.unwrap(value): java.lang.String)
      )(_.imageId)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        snapshotConfiguration.map(value => value.buildAwsValue())
      )(_.snapshotConfiguration)
      .optionallyWith(launchTemplate.map(value => value.buildAwsValue()))(
        _.launchTemplate
      )
      .optionallyWith(
        maxParallelLaunches.map(value => value: java.lang.Integer)
      )(_.maxParallelLaunches)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        stateTransitionReason.map(value => value: java.lang.String)
      )(_.stateTransitionReason)
      .optionallyWith(
        stateTransitionTime.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.stateTransitionTime)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DisableFastLaunchResponse.ReadOnly =
    zio.aws.ec2.model.DisableFastLaunchResponse.wrap(buildAwsValue())
}
object DisableFastLaunchResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisableFastLaunchResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisableFastLaunchResponse =
      zio.aws.ec2.model.DisableFastLaunchResponse(
        imageId.map(value => value),
        resourceType.map(value => value),
        snapshotConfiguration.map(value => value.asEditable),
        launchTemplate.map(value => value.asEditable),
        maxParallelLaunches.map(value => value),
        ownerId.map(value => value),
        state.map(value => value),
        stateTransitionReason.map(value => value),
        stateTransitionTime.map(value => value)
      )
    def imageId: Optional[ImageId]
    def resourceType: Optional[zio.aws.ec2.model.FastLaunchResourceType]
    def snapshotConfiguration: Optional[
      zio.aws.ec2.model.FastLaunchSnapshotConfigurationResponse.ReadOnly
    ]
    def launchTemplate: Optional[
      zio.aws.ec2.model.FastLaunchLaunchTemplateSpecificationResponse.ReadOnly
    ]
    def maxParallelLaunches: Optional[Integer]
    def ownerId: Optional[String]
    def state: Optional[zio.aws.ec2.model.FastLaunchStateCode]
    def stateTransitionReason: Optional[String]
    def stateTransitionTime: Optional[MillisecondDateTime]
    def getImageId: ZIO[Any, AwsError, ImageId] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.ec2.model.FastLaunchResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getSnapshotConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.FastLaunchSnapshotConfigurationResponse.ReadOnly
    ] =
      AwsError.unwrapOptionField("snapshotConfiguration", snapshotConfiguration)
    def getLaunchTemplate: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.FastLaunchLaunchTemplateSpecificationResponse.ReadOnly
    ] = AwsError.unwrapOptionField("launchTemplate", launchTemplate)
    def getMaxParallelLaunches: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxParallelLaunches", maxParallelLaunches)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.FastLaunchStateCode] =
      AwsError.unwrapOptionField("state", state)
    def getStateTransitionReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stateTransitionReason", stateTransitionReason)
    def getStateTransitionTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("stateTransitionTime", stateTransitionTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisableFastLaunchResponse
  ) extends zio.aws.ec2.model.DisableFastLaunchResponse.ReadOnly {
    override val imageId: Optional[ImageId] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => zio.aws.ec2.model.primitives.ImageId(value))
    override val resourceType
        : Optional[zio.aws.ec2.model.FastLaunchResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.ec2.model.FastLaunchResourceType.wrap(value))
    override val snapshotConfiguration: Optional[
      zio.aws.ec2.model.FastLaunchSnapshotConfigurationResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotConfiguration())
      .map(value =>
        zio.aws.ec2.model.FastLaunchSnapshotConfigurationResponse.wrap(value)
      )
    override val launchTemplate: Optional[
      zio.aws.ec2.model.FastLaunchLaunchTemplateSpecificationResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.launchTemplate())
      .map(value =>
        zio.aws.ec2.model.FastLaunchLaunchTemplateSpecificationResponse
          .wrap(value)
      )
    override val maxParallelLaunches: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxParallelLaunches())
      .map(value => value: Integer)
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val state: Optional[zio.aws.ec2.model.FastLaunchStateCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.FastLaunchStateCode.wrap(value))
    override val stateTransitionReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stateTransitionReason())
      .map(value => value: String)
    override val stateTransitionTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateTransitionTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisableFastLaunchResponse
  ): zio.aws.ec2.model.DisableFastLaunchResponse.ReadOnly = new Wrapper(impl)
}
