package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{KeyPairId, KeyPairName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeKeyPairsRequest(
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    keyNames: Optional[Iterable[KeyPairName]] = Optional.Absent,
    keyPairIds: Optional[Iterable[KeyPairId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeKeyPairsRequest = {
    import DescribeKeyPairsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeKeyPairsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        keyNames.map(value =>
          value.map { item =>
            KeyPairName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.keyNames)
      .optionallyWith(
        keyPairIds.map(value =>
          value.map { item =>
            KeyPairId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.keyPairIds)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeKeyPairsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeKeyPairsRequest.wrap(buildAwsValue())
}
object DescribeKeyPairsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeKeyPairsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeKeyPairsRequest =
      zio.aws.ec2.model.DescribeKeyPairsRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        keyNames.map(value => value),
        keyPairIds.map(value => value)
      )
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def keyNames: Optional[List[KeyPairName]]
    def keyPairIds: Optional[List[KeyPairId]]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getKeyNames: ZIO[Any, AwsError, List[KeyPairName]] =
      AwsError.unwrapOptionField("keyNames", keyNames)
    def getKeyPairIds: ZIO[Any, AwsError, List[KeyPairId]] =
      AwsError.unwrapOptionField("keyPairIds", keyPairIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeKeyPairsRequest
  ) extends zio.aws.ec2.model.DescribeKeyPairsRequest.ReadOnly {
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val keyNames: Optional[List[KeyPairName]] = zio.aws.core.internal
      .optionalFromNullable(impl.keyNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.KeyPairName(item)
        }.toList
      )
    override val keyPairIds: Optional[List[KeyPairId]] = zio.aws.core.internal
      .optionalFromNullable(impl.keyPairIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.KeyPairId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeKeyPairsRequest
  ): zio.aws.ec2.model.DescribeKeyPairsRequest.ReadOnly = new Wrapper(impl)
}
