package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeIdentityIdFormatRequest(
    principalArn: String,
    resource: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeIdentityIdFormatRequest = {
    import DescribeIdentityIdFormatRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeIdentityIdFormatRequest
      .builder()
      .principalArn(principalArn: java.lang.String)
      .optionallyWith(resource.map(value => value: java.lang.String))(
        _.resource
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeIdentityIdFormatRequest.ReadOnly =
    zio.aws.ec2.model.DescribeIdentityIdFormatRequest.wrap(buildAwsValue())
}
object DescribeIdentityIdFormatRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeIdentityIdFormatRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeIdentityIdFormatRequest =
      zio.aws.ec2.model.DescribeIdentityIdFormatRequest(
        principalArn,
        resource.map(value => value)
      )
    def principalArn: String
    def resource: Optional[String]
    def getPrincipalArn: ZIO[Any, Nothing, String] = ZIO.succeed(principalArn)
    def getResource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resource", resource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIdentityIdFormatRequest
  ) extends zio.aws.ec2.model.DescribeIdentityIdFormatRequest.ReadOnly {
    override val principalArn: String = impl.principalArn(): String
    override val resource: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resource())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIdentityIdFormatRequest
  ): zio.aws.ec2.model.DescribeIdentityIdFormatRequest.ReadOnly = new Wrapper(
    impl
  )
}
