package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeCapacityReservationsResponse(
    nextToken: Optional[String] = Optional.Absent,
    capacityReservations: Optional[
      Iterable[zio.aws.ec2.model.CapacityReservation]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsResponse = {
    import DescribeCapacityReservationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        capacityReservations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.capacityReservations)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeCapacityReservationsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeCapacityReservationsResponse.wrap(buildAwsValue())
}
object DescribeCapacityReservationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeCapacityReservationsResponse =
      zio.aws.ec2.model.DescribeCapacityReservationsResponse(
        nextToken.map(value => value),
        capacityReservations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def capacityReservations
        : Optional[List[zio.aws.ec2.model.CapacityReservation.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getCapacityReservations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.CapacityReservation.ReadOnly
    ]] =
      AwsError.unwrapOptionField("capacityReservations", capacityReservations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsResponse
  ) extends zio.aws.ec2.model.DescribeCapacityReservationsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val capacityReservations
        : Optional[List[zio.aws.ec2.model.CapacityReservation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityReservations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.CapacityReservation.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationsResponse
  ): zio.aws.ec2.model.DescribeCapacityReservationsResponse.ReadOnly =
    new Wrapper(impl)
}
