package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteTrafficMirrorFilterResponse(
    trafficMirrorFilterId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterResponse = {
    import DeleteTrafficMirrorFilterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterResponse
      .builder()
      .optionallyWith(
        trafficMirrorFilterId.map(value => value: java.lang.String)
      )(_.trafficMirrorFilterId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteTrafficMirrorFilterResponse.ReadOnly =
    zio.aws.ec2.model.DeleteTrafficMirrorFilterResponse.wrap(buildAwsValue())
}
object DeleteTrafficMirrorFilterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteTrafficMirrorFilterResponse =
      zio.aws.ec2.model.DeleteTrafficMirrorFilterResponse(
        trafficMirrorFilterId.map(value => value)
      )
    def trafficMirrorFilterId: Optional[String]
    def getTrafficMirrorFilterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("trafficMirrorFilterId", trafficMirrorFilterId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterResponse
  ) extends zio.aws.ec2.model.DeleteTrafficMirrorFilterResponse.ReadOnly {
    override val trafficMirrorFilterId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.trafficMirrorFilterId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterResponse
  ): zio.aws.ec2.model.DeleteTrafficMirrorFilterResponse.ReadOnly = new Wrapper(
    impl
  )
}
