package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteNatGatewayResponse(
    natGatewayId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteNatGatewayResponse = {
    import DeleteNatGatewayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteNatGatewayResponse
      .builder()
      .optionallyWith(natGatewayId.map(value => value: java.lang.String))(
        _.natGatewayId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteNatGatewayResponse.ReadOnly =
    zio.aws.ec2.model.DeleteNatGatewayResponse.wrap(buildAwsValue())
}
object DeleteNatGatewayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteNatGatewayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteNatGatewayResponse =
      zio.aws.ec2.model
        .DeleteNatGatewayResponse(natGatewayId.map(value => value))
    def natGatewayId: Optional[String]
    def getNatGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("natGatewayId", natGatewayId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNatGatewayResponse
  ) extends zio.aws.ec2.model.DeleteNatGatewayResponse.ReadOnly {
    override val natGatewayId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.natGatewayId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNatGatewayResponse
  ): zio.aws.ec2.model.DeleteNatGatewayResponse.ReadOnly = new Wrapper(impl)
}
