package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.CarrierGatewayId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteCarrierGatewayRequest(
    carrierGatewayId: CarrierGatewayId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteCarrierGatewayRequest = {
    import DeleteCarrierGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteCarrierGatewayRequest
      .builder()
      .carrierGatewayId(
        CarrierGatewayId.unwrap(carrierGatewayId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteCarrierGatewayRequest.ReadOnly =
    zio.aws.ec2.model.DeleteCarrierGatewayRequest.wrap(buildAwsValue())
}
object DeleteCarrierGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteCarrierGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteCarrierGatewayRequest =
      zio.aws.ec2.model.DeleteCarrierGatewayRequest(carrierGatewayId)
    def carrierGatewayId: CarrierGatewayId
    def getCarrierGatewayId: ZIO[Any, Nothing, CarrierGatewayId] =
      ZIO.succeed(carrierGatewayId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteCarrierGatewayRequest
  ) extends zio.aws.ec2.model.DeleteCarrierGatewayRequest.ReadOnly {
    override val carrierGatewayId: CarrierGatewayId =
      zio.aws.ec2.model.primitives.CarrierGatewayId(impl.carrierGatewayId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteCarrierGatewayRequest
  ): zio.aws.ec2.model.DeleteCarrierGatewayRequest.ReadOnly = new Wrapper(impl)
}
