package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateVpcEndpointResponse(
    vpcEndpoint: Optional[zio.aws.ec2.model.VpcEndpoint] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVpcEndpointResponse = {
    import CreateVpcEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVpcEndpointResponse
      .builder()
      .optionallyWith(vpcEndpoint.map(value => value.buildAwsValue()))(
        _.vpcEndpoint
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateVpcEndpointResponse.ReadOnly =
    zio.aws.ec2.model.CreateVpcEndpointResponse.wrap(buildAwsValue())
}
object CreateVpcEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVpcEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateVpcEndpointResponse =
      zio.aws.ec2.model.CreateVpcEndpointResponse(
        vpcEndpoint.map(value => value.asEditable),
        clientToken.map(value => value)
      )
    def vpcEndpoint: Optional[zio.aws.ec2.model.VpcEndpoint.ReadOnly]
    def clientToken: Optional[String]
    def getVpcEndpoint
        : ZIO[Any, AwsError, zio.aws.ec2.model.VpcEndpoint.ReadOnly] =
      AwsError.unwrapOptionField("vpcEndpoint", vpcEndpoint)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpcEndpointResponse
  ) extends zio.aws.ec2.model.CreateVpcEndpointResponse.ReadOnly {
    override val vpcEndpoint: Optional[zio.aws.ec2.model.VpcEndpoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcEndpoint())
        .map(value => zio.aws.ec2.model.VpcEndpoint.wrap(value))
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpcEndpointResponse
  ): zio.aws.ec2.model.CreateVpcEndpointResponse.ReadOnly = new Wrapper(impl)
}
