package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateStoreImageTaskResponse(
    objectKey: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateStoreImageTaskResponse = {
    import CreateStoreImageTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateStoreImageTaskResponse
      .builder()
      .optionallyWith(objectKey.map(value => value: java.lang.String))(
        _.objectKey
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateStoreImageTaskResponse.ReadOnly =
    zio.aws.ec2.model.CreateStoreImageTaskResponse.wrap(buildAwsValue())
}
object CreateStoreImageTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateStoreImageTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateStoreImageTaskResponse =
      zio.aws.ec2.model
        .CreateStoreImageTaskResponse(objectKey.map(value => value))
    def objectKey: Optional[String]
    def getObjectKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("objectKey", objectKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateStoreImageTaskResponse
  ) extends zio.aws.ec2.model.CreateStoreImageTaskResponse.ReadOnly {
    override val objectKey: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.objectKey())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateStoreImageTaskResponse
  ): zio.aws.ec2.model.CreateStoreImageTaskResponse.ReadOnly = new Wrapper(impl)
}
