package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, FlowLogResourceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateFlowLogsRequest(
    clientToken: Optional[String] = Optional.Absent,
    deliverLogsPermissionArn: Optional[String] = Optional.Absent,
    logGroupName: Optional[String] = Optional.Absent,
    resourceIds: Iterable[FlowLogResourceId],
    resourceType: zio.aws.ec2.model.FlowLogsResourceType,
    trafficType: zio.aws.ec2.model.TrafficType,
    logDestinationType: Optional[zio.aws.ec2.model.LogDestinationType] =
      Optional.Absent,
    logDestination: Optional[String] = Optional.Absent,
    logFormat: Optional[String] = Optional.Absent,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent,
    maxAggregationInterval: Optional[Integer] = Optional.Absent,
    destinationOptions: Optional[zio.aws.ec2.model.DestinationOptionsRequest] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateFlowLogsRequest = {
    import CreateFlowLogsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateFlowLogsRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(
        deliverLogsPermissionArn.map(value => value: java.lang.String)
      )(_.deliverLogsPermissionArn)
      .optionallyWith(logGroupName.map(value => value: java.lang.String))(
        _.logGroupName
      )
      .resourceIds(resourceIds.map { item =>
        FlowLogResourceId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .resourceType(resourceType.unwrap)
      .trafficType(trafficType.unwrap)
      .optionallyWith(logDestinationType.map(value => value.unwrap))(
        _.logDestinationType
      )
      .optionallyWith(logDestination.map(value => value: java.lang.String))(
        _.logDestination
      )
      .optionallyWith(logFormat.map(value => value: java.lang.String))(
        _.logFormat
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(
        maxAggregationInterval.map(value => value: java.lang.Integer)
      )(_.maxAggregationInterval)
      .optionallyWith(destinationOptions.map(value => value.buildAwsValue()))(
        _.destinationOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateFlowLogsRequest.ReadOnly =
    zio.aws.ec2.model.CreateFlowLogsRequest.wrap(buildAwsValue())
}
object CreateFlowLogsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateFlowLogsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateFlowLogsRequest =
      zio.aws.ec2.model.CreateFlowLogsRequest(
        clientToken.map(value => value),
        deliverLogsPermissionArn.map(value => value),
        logGroupName.map(value => value),
        resourceIds,
        resourceType,
        trafficType,
        logDestinationType.map(value => value),
        logDestination.map(value => value),
        logFormat.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxAggregationInterval.map(value => value),
        destinationOptions.map(value => value.asEditable)
      )
    def clientToken: Optional[String]
    def deliverLogsPermissionArn: Optional[String]
    def logGroupName: Optional[String]
    def resourceIds: List[FlowLogResourceId]
    def resourceType: zio.aws.ec2.model.FlowLogsResourceType
    def trafficType: zio.aws.ec2.model.TrafficType
    def logDestinationType: Optional[zio.aws.ec2.model.LogDestinationType]
    def logDestination: Optional[String]
    def logFormat: Optional[String]
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def maxAggregationInterval: Optional[Integer]
    def destinationOptions
        : Optional[zio.aws.ec2.model.DestinationOptionsRequest.ReadOnly]
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDeliverLogsPermissionArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("deliverLogsPermissionArn", deliverLogsPermissionArn)
    def getLogGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logGroupName", logGroupName)
    def getResourceIds: ZIO[Any, Nothing, List[FlowLogResourceId]] =
      ZIO.succeed(resourceIds)
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.ec2.model.FlowLogsResourceType] =
      ZIO.succeed(resourceType)
    def getTrafficType: ZIO[Any, Nothing, zio.aws.ec2.model.TrafficType] =
      ZIO.succeed(trafficType)
    def getLogDestinationType
        : ZIO[Any, AwsError, zio.aws.ec2.model.LogDestinationType] =
      AwsError.unwrapOptionField("logDestinationType", logDestinationType)
    def getLogDestination: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logDestination", logDestination)
    def getLogFormat: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logFormat", logFormat)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getMaxAggregationInterval: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("maxAggregationInterval", maxAggregationInterval)
    def getDestinationOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.DestinationOptionsRequest.ReadOnly
    ] = AwsError.unwrapOptionField("destinationOptions", destinationOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateFlowLogsRequest
  ) extends zio.aws.ec2.model.CreateFlowLogsRequest.ReadOnly {
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val deliverLogsPermissionArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deliverLogsPermissionArn())
        .map(value => value: String)
    override val logGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.logGroupName())
      .map(value => value: String)
    override val resourceIds: List[FlowLogResourceId] = impl
      .resourceIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.FlowLogResourceId(item)
      }
      .toList
    override val resourceType: zio.aws.ec2.model.FlowLogsResourceType =
      zio.aws.ec2.model.FlowLogsResourceType.wrap(impl.resourceType())
    override val trafficType: zio.aws.ec2.model.TrafficType =
      zio.aws.ec2.model.TrafficType.wrap(impl.trafficType())
    override val logDestinationType
        : Optional[zio.aws.ec2.model.LogDestinationType] = zio.aws.core.internal
      .optionalFromNullable(impl.logDestinationType())
      .map(value => zio.aws.ec2.model.LogDestinationType.wrap(value))
    override val logDestination: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.logDestination())
      .map(value => value: String)
    override val logFormat: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.logFormat())
      .map(value => value: String)
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
    override val maxAggregationInterval: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxAggregationInterval())
        .map(value => value: Integer)
    override val destinationOptions
        : Optional[zio.aws.ec2.model.DestinationOptionsRequest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationOptions())
        .map(value => zio.aws.ec2.model.DestinationOptionsRequest.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateFlowLogsRequest
  ): zio.aws.ec2.model.CreateFlowLogsRequest.ReadOnly = new Wrapper(impl)
}
