package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDefaultVpcResponse(
    vpc: Optional[zio.aws.ec2.model.Vpc] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateDefaultVpcResponse = {
    import CreateDefaultVpcResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateDefaultVpcResponse
      .builder()
      .optionallyWith(vpc.map(value => value.buildAwsValue()))(_.vpc)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateDefaultVpcResponse.ReadOnly =
    zio.aws.ec2.model.CreateDefaultVpcResponse.wrap(buildAwsValue())
}
object CreateDefaultVpcResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateDefaultVpcResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateDefaultVpcResponse =
      zio.aws.ec2.model
        .CreateDefaultVpcResponse(vpc.map(value => value.asEditable))
    def vpc: Optional[zio.aws.ec2.model.Vpc.ReadOnly]
    def getVpc: ZIO[Any, AwsError, zio.aws.ec2.model.Vpc.ReadOnly] =
      AwsError.unwrapOptionField("vpc", vpc)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateDefaultVpcResponse
  ) extends zio.aws.ec2.model.CreateDefaultVpcResponse.ReadOnly {
    override val vpc: Optional[zio.aws.ec2.model.Vpc.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpc())
        .map(value => zio.aws.ec2.model.Vpc.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateDefaultVpcResponse
  ): zio.aws.ec2.model.CreateDefaultVpcResponse.ReadOnly = new Wrapper(impl)
}
