package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ConversionTaskState {
  def unwrap: software.amazon.awssdk.services.ec2.model.ConversionTaskState
}
object ConversionTaskState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ConversionTaskState
  ): zio.aws.ec2.model.ConversionTaskState = value match {
    case software.amazon.awssdk.services.ec2.model.ConversionTaskState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ConversionTaskState.ACTIVE =>
      val r = active
      r
    case software.amazon.awssdk.services.ec2.model.ConversionTaskState.CANCELLING =>
      val r = cancelling
      r
    case software.amazon.awssdk.services.ec2.model.ConversionTaskState.CANCELLED =>
      val r = cancelled
      r
    case software.amazon.awssdk.services.ec2.model.ConversionTaskState.COMPLETED =>
      val r = completed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.ConversionTaskState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ConversionTaskState =
      software.amazon.awssdk.services.ec2.model.ConversionTaskState.UNKNOWN_TO_SDK_VERSION
  }
  case object active extends zio.aws.ec2.model.ConversionTaskState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ConversionTaskState =
      software.amazon.awssdk.services.ec2.model.ConversionTaskState.ACTIVE
  }
  case object cancelling extends zio.aws.ec2.model.ConversionTaskState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ConversionTaskState =
      software.amazon.awssdk.services.ec2.model.ConversionTaskState.CANCELLING
  }
  case object cancelled extends zio.aws.ec2.model.ConversionTaskState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ConversionTaskState =
      software.amazon.awssdk.services.ec2.model.ConversionTaskState.CANCELLED
  }
  case object completed extends zio.aws.ec2.model.ConversionTaskState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ConversionTaskState =
      software.amazon.awssdk.services.ec2.model.ConversionTaskState.COMPLETED
  }
}
