package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ConnectionNotificationState {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.ConnectionNotificationState
}
object ConnectionNotificationState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ConnectionNotificationState
  ): zio.aws.ec2.model.ConnectionNotificationState = value match {
    case software.amazon.awssdk.services.ec2.model.ConnectionNotificationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ConnectionNotificationState.ENABLED =>
      val r = Enabled
      r
    case software.amazon.awssdk.services.ec2.model.ConnectionNotificationState.DISABLED =>
      val r = Disabled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.ConnectionNotificationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ConnectionNotificationState =
      software.amazon.awssdk.services.ec2.model.ConnectionNotificationState.UNKNOWN_TO_SDK_VERSION
  }
  case object Enabled extends zio.aws.ec2.model.ConnectionNotificationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ConnectionNotificationState =
      software.amazon.awssdk.services.ec2.model.ConnectionNotificationState.ENABLED
  }
  case object Disabled extends zio.aws.ec2.model.ConnectionNotificationState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ConnectionNotificationState =
      software.amazon.awssdk.services.ec2.model.ConnectionNotificationState.DISABLED
  }
}
